---@enum EB1AccessoryMaterialType
local EB1AccessoryMaterialType = {
    None = 0,
    Jewelry = 1,
    Accessory = 2,
    Glass = 3,
    Hair = 4,
    Max = 255,
}

---@enum EB1AccessoryType
local EB1AccessoryType = {
    None = 0,
    Glasses = 1,
    Earring = 2,
    HairAccessory = 3,
    Piercing = 4,
    MAX = 255,
}

---@enum EB1ActingType
local EB1ActingType = {
    None = 0,
    Essencial = 1,
    Loop = 2,
    EB1ActingType_MAX = 3,
}

---@enum EB1ActionType
local EB1ActionType = {
    Invalid = 0,
    WalkTo = 1,
    WalkToCompany = 2,
    WalkToHome = 3,
    WalkToNearby = 4,
    WalkToNearestRoad = 5,
    WalkToNearestCityGraph = 6,
    WalkToSite = 7,
    WalkToNonCancelable = 8,
    WalkToPortal = 9,
    WalkToSubway = 10,
    WalkToVehicle = 11,
    TeleportTo = 12,
    PlayAnim = 13,
    PlayLoopAnim = 14,
    PlayVATAnim = 15,
    RotateTo = 16,
    ChangePosture = 17,
    PickUp = 18,
    PickUpAuto = 19,
    PickUpCharacter = 20,
    PutDown = 21,
    PutDownInventoryObject = 22,
    PutDownDestroy = 23,
    Delay = 24,
    WaitForAsyncLoad = 25,
    Sleep = 26,
    Work = 27,
    Sit = 28,
    ChangeCostume = 29,
    ChangeOutfitCategory = 30,
    RemoveCostumeByActionReason = 31,
    BookRead = 32,
    Eat = 33,
    RabbitHole = 34,
    EditCharacter = 35,
    UpdateAging = 36,
    Coop = 37,
    CoopSelect = 38,
    WaitCoopResponse = 39,
    WaitTalkSequence = 40,
    WaitTalkPositioning = 41,
    WalkToContext = 42,
    RotateToContext = 43,
    PlayAnimContext = 44,
    TalkContext = 45,
    LevelSequence = 46,
    WalkAroundSite = 47,
    WalkAroundLocation = 48,
    RequestEnterVehicle = 49,
    ChangeVehiclePartState = 50,
    MoveWithVehicle = 51,
    SpawnVehicle = 52,
    ChangePostureSit = 53,
    WalkToDirtyPlace = 54,
    WalkToSpawner = 55,
    WalkToLocation = 56,
    GrabInventoryObject = 57,
    PopupMessage = 58,
    PlayVideo = 59,
    Die = 60,
    LaunchCraft = 61,
    StartCrafting = 62,
    ContinueCrafting = 63,
    ProgressCrafting = 64,
    CleanDusty = 65,
    Buy = 66,
    RunAway = 67,
    CraftBulidMode = 68,
    RegisterPocketMarketItem = 69,
    SelectSlotOwnership = 70,
    GenerateMotion = 71,
    PlayGeneratedMotion = 72,
    WalkToSharedSiteSpawner = 73,
    EB1ActionType_MAX = 74,
}

---@enum EB1AddInteractionQueueResult
local EB1AddInteractionQueueResult = {
    None = 0,
    InvalidInteractionBagId = 1,
    InvalidInteractionDataAsset = 2,
    InvalidInteractionMessageDataAsset = 3,
    InvalidPlayerController = 4,
    InvalidSlotManager = 5,
    InvalidObjectGroupManager = 6,
    InvalidRootDepartmentInfo = 7,
    InvalidCoopManager = 8,
    InvalidObjectTableRow = 9,
    InvalidOwner = 10,
    InvalidJobComponent = 11,
    InvalidSelectionSet = 12,
    CompanyOnly = 13,
    MaxInteractionQueue = 14,
    UniqueIsInQueue = 15,
    EnqueueConditionCheckFail = 16,
    AgingCondition = 17,
    NotExistSeatPool = 18,
    NotMyFixedSeat = 19,
    Coop = 20,
    Talk = 21,
    CurrentInteractionIsWalkToScheduleSite = 22,
    DevObjectFilter = 23,
    NoneAvaiableInteractionObject = 24,
    NotFoundVehicleData = 25,
    NotExistPlayReason = 26,
    NotSimulatedEntity = 27,
    InteractionNotForGhost = 28,
    InteractionNotForAlive = 29,
    InInventory = 30,
    NotAccessApprovedCarriableObject = 31,
    NotInMyInventory = 32,
    BuildWorld = 33,
    GrabBaby = 34,
    Success = 35,
    EB1AddInteractionQueueResult_MAX = 36,
}

---@enum EB1AffectType
local EB1AffectType = {
    None = 0,
    Perspective = 1,
    Skill = 2,
    Preference = 3,
    Job = 4,
    AppearancePreset = 5,
    EB1AffectType_MAX = 6,
}

---@enum EB1AlertType
local EB1AlertType = {
    None = 0,
    Skill = 1,
    RelationshipChanged = 2,
    RelationshipBegin = 3,
    RelationshipEnd = 4,
    NewFamilyMoveIn = 5,
    ValuesDisabled = 6,
    AmbitionDisabled = 7,
    PreferenceDisabled = 8,
    HobbyDisabled = 9,
    JobDisabled = 10,
    ChangeJobId = 11,
    JobRankUp = 12,
    JobRankDown = 13,
    JoinCompany = 14,
    LeaveCompany = 15,
    WarningFired = 16,
    MobileMessage = 17,
    JobInducementType = 18,
    PreferenceSelect = 19,
    MobileMessagePlain = 20,
    LeaveCompanyByAge = 21,
    JoinSchool = 22,
    LeaveSchool = 23,
    EducationRankUp = 24,
    EducationRankDown = 25,
    GraduationSchool = 26,
    WarningExpel = 27,
    ExpelledSchool = 28,
    EB1AlertType_MAX = 29,
}

---@enum EB1AnimGrowthStep
local EB1AnimGrowthStep = {
    Default = 0,
    Adult = 1,
    Youth = 2,
    Baby = 3,
    Elderly = 4,
    Infant = 5,
    EB1AnimGrowthStep_MAX = 6,
}

---@enum EB1AnimNotifyEventState
local EB1AnimNotifyEventState = {
    Invalid = 0,
    Wait = 1,
    Began = 2,
    Ended = 3,
    EB1AnimNotifyEventState_MAX = 4,
}

---@enum EB1AnimNotifyEventType
local EB1AnimNotifyEventType = {
    Invalid = 0,
    XXX = 1,
    B1PlayAnim = 2,
    B1LoopEnd = 3,
    B1RunScript = 4,
    B1PlayStaticMeshAnim = 5,
    B1EnterVehicle = 6,
    B1ExitVehicle = 7,
    B1ChangeState = 8,
    B1LadderRightStep = 9,
    EB1AnimNotifyEventType_MAX = 10,
}

---@enum EB1Anim_Direction
local EB1Anim_Direction = {
    Forward = 0,
    Left = 1,
    Right = 2,
    Backward_L = 3,
    Backward_R = 4,
    EB1Anim_MAX = 5,
}

---@enum EB1Anim_OneStep
local EB1Anim_OneStep = {
    None = 0,
    Forward = 1,
    Back = 2,
    L_90 = 3,
    R_90 = 4,
    MAX = 5,
}

---@enum EB1Anim_Slope
local EB1Anim_Slope = {
    Flat = 0,
    Upside = 1,
    Downside = 2,
    EB1Anim_MAX = 3,
}

---@enum EB1Anim_TurnAnim
local EB1Anim_TurnAnim = {
    None = 0,
    TurnStop_Forward = 1,
    TurnStop_L90 = 2,
    TurnStop_R90 = 3,
    TurnStop_L180 = 4,
    TurnStop_R180 = 5,
    TurnInPlace_L90 = 6,
    TurnInPlace_R90 = 7,
    TurnInPlace_L180 = 8,
    TurnInPlace_R180 = 9,
    BackStep = 10,
    SideStep_L = 11,
    SideStep_R = 12,
    EB1Anim_MAX = 13,
}

---@enum EB1Anim_TurnStop
local EB1Anim_TurnStop = {
    None = 0,
    FORWARD = 1,
    L_90 = 2,
    R_90 = 3,
    L_180 = 4,
    R_180 = 5,
    MAX = 6,
}

---@enum EB1AnimationDirection
local EB1AnimationDirection = {
    None = 0,
    Left = 1,
    Right = 2,
    EB1AnimationDirection_MAX = 3,
}

---@enum EB1AppearanceParts
local EB1AppearanceParts = {
    Body = 0,
    Head = 1,
    Top = 2,
    Bottom = 3,
    Shoes = 4,
    Jacket = 5,
    Hat = 6,
    Socks = 7,
    InnerTop = 8,
    InnerUnder = 9,
    Hair = 10,
    Garment = 11,
    FaceHair = 12,
    EB1AppearanceParts_MAX = 13,
}

---@enum EB1AudioGroupType
local EB1AudioGroupType = {
    None = 0,
    Master = 1,
    Music = 2,
    SFX = 3,
    UI = 4,
    Voice = 5,
    Cinematics = 6,
    EB1AudioGroupType_MAX = 7,
}

---@enum EB1AutoDrivingStopReason
local EB1AutoDrivingStopReason = {
    None = 0,
    UserInput = 1,
    InteractionCancelled = 2,
    Collision = 3,
    Freeze = 4,
    EB1AutoDrivingStopReason_MAX = 5,
}

---@enum EB1AutoFindTargetType
local EB1AutoFindTargetType = {
    None = 0,
    Picked = 1,
    InteractionBagId = 2,
    InteractionBagCategory = 3,
    ObjectId = 4,
    ObjectCategory = 5,
    Character = 6,
    CarriedObject = 7,
    ConnectedChairObject = 8,
    EB1AutoFindTargetType_MAX = 9,
}

---@enum EB1AvoidanceType
local EB1AvoidanceType = {
    None = 0,
    L_45 = 1,
    L_90 = 2,
    L_135 = 3,
    L_180 = 4,
    R_45 = 5,
    R_90 = 6,
    R_135 = 7,
    R_180 = 8,
    L_Back = 9,
    R_Back = 10,
    EB1AvoidanceType_MAX = 11,
}

---@enum EB1BGMTransitionType
local EB1BGMTransitionType = {
    Immediate = 0,
    SameTime = 1,
    LastExitPosition = 2,
    Max = 3,
}

---@enum EB1BGMType
local EB1BGMType = {
    None = 0,
    LobbyScene = 1,
    CustomizeFamilyScene = 2,
    BuildModeScene = 3,
    MinimapScene = 4,
    InGameScene = 5,
    LoadingScene = 6,
    CatShopScene = 7,
    EB1BGMType_MAX = 8,
}

---@enum EB1BaseHousehold
local EB1BaseHousehold = {
    Left = 0,
    Right = 1,
    Center = 2,
    EB1BaseHousehold_MAX = 3,
}

---@enum EB1BaseObject
local EB1BaseObject = {
    Invalid = 0,
    Self = 1,
    Target = 2,
    EB1BaseObject_MAX = 3,
}

---@enum EB1BodyAgeType
local EB1BodyAgeType = {
    Invalid = 0,
    Default = 1,
    Adult = 2,
    Youth = 3,
    Baby = 4,
    EB1BodyAgeType_MAX = 5,
}

---@enum EB1BodyRegion
local EB1BodyRegion = {
    None = 0,
    ChestUpper = 1,
    ChestMid = 2,
    LeftShoulder = 4,
    LeftArmUpper = 8,
    LeftElbow = 16,
    LeftWrist = 32,
    RightShoulder = 64,
    RightArmUpper = 128,
    RightElbow = 256,
    RightWrist = 512,
    LeftHand = 1024,
    RightHand = 2048,
    ChestLower = 4096,
    BellyUpper = 8192,
    BackUpper = 16384,
    WaistBack = 32768,
    Pelvis = 65536,
    Crotch = 131072,
    LeftThighUpper = 262144,
    LeftThighLower = 524288,
    LeftKnee = 1048576,
    LeftShin = 2097152,
    LeftFoot = 4194304,
    LeftToe = 8388608,
    RightThighUpper = 16777216,
    RightThighLower = 33554432,
    RightKnee = 67108864,
    RightShin = 134217728,
    RightFoot = 268435456,
    RightToe = 536870912,
    WaistLower = 1073741824,
    BellyLower = -2147483648,
    LAST = -2147483648,
    LeftArmShort = 12,
    RightArmShort = 192,
    LeftArmMid = 28,
    RightArmMid = 448,
    LeftArm = 60,
    RightArm = 960,
    Shoulders = 68,
    ArmsAll = 1020,
    ArmsAllMid = 476,
    ArmsAllShort = 204,
    Gloves = 3072,
    UpperBodyShort = 16384,
    UpperBodyShortClosed = 16387,
    UpperBody = 49152,
    UpperBodyClosed = 61443,
    Waist = 40960,
    LowerWaist = -1073741824,
    BackBody = 49152,
    BackAndArms = 50172,
    BottomMinimal = 196608,
    BottomShort = 17235968,
    BottomHalf = 51314688,
    BottomMid = 119472128,
    BottomLong = 255787008,
    Shoes = 545259520,
    Socks = 817889280,
    SocksLong = 954204160,
    Boots = 817889280,
    BootsLong = 954204160,
    WholeBody = 1073741823,
    MAX = 1073741823,
}

---@enum EB1BoneScaleGroupCategory
local EB1BoneScaleGroupCategory = {
    None = 0,
    Body = 1,
    Face = 2,
    BodyAndFace = 3,
    EB1BoneScaleGroupCategory_MAX = 4,
}

---@enum EB1ButtonType
local EB1ButtonType = {
    None = 0,
    PrimaryPositive = 1,
    PrimaryNegative = 2,
    Secondary = 3,
    Primary = 4,
    PrimaryHighlight = 5,
    EB1ButtonType_MAX = 6,
}

---@enum EB1CameraModeType
local EB1CameraModeType = {
    ShoulderView = 0,
    QuarterView = 1,
    Free = 2,
    AppearanceView = 3,
    TraitSelect = 4,
    BuildView = 5,
    CCTV = 6,
    Map = 7,
    Lobby = 8,
    Vehicle = 9,
    PhotoMode = 10,
    LevelSequence = 11,
    GenerateMotion = 12,
    End = 13,
    EB1CameraModeType_MAX = 14,
}

---@enum EB1CarriableObjectType
local EB1CarriableObjectType = {
    Object = 0,
    Book = 1,
    Food = 2,
    CraftObject = 3,
    Invalid = 4,
    EB1CarriableObjectType_MAX = 5,
}

---@enum EB1ChainBoneType
local EB1ChainBoneType = {
    Invalid = 0,
    Hand_R = 1,
    Hand_L = 2,
    EB1ChainBoneType_MAX = 3,
}

---@enum EB1ChangeFreeCameraGuide
local EB1ChangeFreeCameraGuide = {
    None = 0,
    TopToShoulder = 1,
    ShoulderToTop = 2,
    EB1ChangeFreeCameraGuide_MAX = 3,
}

---@enum EB1ChangeOutfitReason
local EB1ChangeOutfitReason = {
    Invalid = 0,
    Action = 1,
    Script = 2,
    SocialEvent = 3,
    IndoorOutfit = 4,
    AppearanceCharacter = 5,
    EB1ChangeOutfitReason_MAX = 6,
}

---@enum EB1CharacterControlType
local EB1CharacterControlType = {
    Client = 0,
    Simulation = 1,
    EB1CharacterControlType_MAX = 2,
}

---@enum EB1CharacterCustomizationCategory
local EB1CharacterCustomizationCategory = {
    None = 0,
    Preset = 1,
    Face = 2,
    Body = 3,
    Costume = 4,
    CostumeEdit = 5,
    Accessory = 6,
    EB1CharacterCustomizationCategory_MAX = 7,
}

---@enum EB1CharacterCustomizationUIListCategoryType
local EB1CharacterCustomizationUIListCategoryType = {
    Default = 0,
    Garment = 1,
    Accessory = 2,
    BodyPreset = 3,
    BodyWeight = 4,
    BodyHair = 5,
    GarmentPreset = 6,
    MakeupPreset = 7,
    CollabPreset = 8,
    DevPreset = 9,
    Makeup = 10,
    Hair = 11,
    SkinFeatures = 12,
    Mole = 13,
    Freckles = 14,
    Scar = 15,
    Tattoo = 16,
    EB1CharacterCustomizationUIListCategoryType_MAX = 17,
}

---@enum EB1CharacterCustomizationUIMenuType
local EB1CharacterCustomizationUIMenuType = {
    None = 0,
    Preset = 1,
    Face = 2,
    Body = 3,
    Costume = 4,
    CostumeEdit = 5,
    FacePreset = 6,
    Makeup = 7,
    Hair = 8,
    Accessory = 9,
    Skin = 10,
    SkinFeatures = 11,
    Eyes = 12,
    EB1CharacterCustomizationUIMenuType_MAX = 13,
}

---@enum EB1CharacterCustomizeCostumeEditCategoryType
local EB1CharacterCustomizeCostumeEditCategoryType = {
    None = 0,
    Shirt = 1,
    Pants = 2,
    Skirt = 3,
    Watch = 4,
    Necklace = 5,
    Attachment3D = 6,
    EB1CharacterCustomizeCostumeEditCategoryType_MAX = 7,
}

---@enum EB1CharacterCustomizeSkinFeaturesType
local EB1CharacterCustomizeSkinFeaturesType = {
    None = 0,
    Mole = 1,
    Freckles = 2,
    Scar = 3,
    Tattoo = 4,
    EB1CharacterCustomizeSkinFeaturesType_MAX = 5,
}

---@enum EB1CharacterCustomizeUIGarmentListType
local EB1CharacterCustomizeUIGarmentListType = {
    DefaultGarmentOnly = 0,
    CustomGarmentOnly = 1,
    All = 2,
    EB1CharacterCustomizeUIGarmentListType_MAX = 3,
}

---@enum EB1CharacterDataCacheGroup
local EB1CharacterDataCacheGroup = {
    Invalid = 0,
    PossessBase = 1,
    PossessTick = 2,
    PossessHousehold = 3,
    PossessRelationship = 4,
    Compact = 5,
    CompactTick = 6,
    EB1CharacterDataCacheGroup_MAX = 7,
}

---@enum EB1CharacterDataCacheType
local EB1CharacterDataCacheType = {
    Invalid = 0,
    Stat = 1,
    Buff = 2,
    Base = 3,
    Bio = 4,
    Appearance = 5,
    Emotion = 6,
    Job = 7,
    EB1CharacterDataCacheType_MAX = 8,
}

---@enum EB1CharacterGroupType
local EB1CharacterGroupType = {
    Invalid = 0,
    ResidenceFamily = 1,
    CompanyRoleNpc = 2,
    SiteRoleNpc = 3,
    Crowd = 4,
    EventCrowd = 5,
    Ghost = 6,
    ServiceNpc = 7,
    EB1CharacterGroupType_MAX = 8,
}

---@enum EB1CharacterNameFormatType
local EB1CharacterNameFormatType = {
    FirstNameLastName = 0,
    LastNameFirstName = 1,
    EB1CharacterNameFormatType_MAX = 2,
}

---@enum EB1CharacterRole
local EB1CharacterRole = {
    Invalid = 0,
    Police = 1,
    FireFighter = 2,
    EB1CharacterRole_MAX = 3,
}

---@enum EB1ChatbotType
local EB1ChatbotType = {
    Invalid = 0,
    FreeChat = 1,
    VideoChat = 2,
    Tutorial = 3,
    EB1ChatbotType_MAX = 4,
}

---@enum EB1CheatUIType
local EB1CheatUIType = {
    Normal = 0,
    Slider = 1,
    EB1CheatUIType_MAX = 2,
}

---@enum EB1CityAudioResourceType
local EB1CityAudioResourceType = {
    None = 0,
    Day = 1,
    Night = 2,
    EB1CityAudioResourceType_MAX = 3,
}

---@enum EB1CityGraphCategory
local EB1CityGraphCategory = {
    Invalid = 0,
    Pedestrian = 1,
    Vehicle = 2,
    EB1CityGraphCategory_MAX = 3,
}

---@enum EB1CityGraphLaneFlags
local EB1CityGraphLaneFlags = {
    None = 0,
    Sparse = 1,
    Warp = 2,
    EB1CityGraphLaneFlags_MAX = 3,
}

---@enum EB1CityGraphLaneLinkDirection
local EB1CityGraphLaneLinkDirection = {
    Invalid = 0,
    None = 1,
    Left = 2,
    Right = 4,
    EB1CityGraphLaneLinkDirection_MAX = 5,
}

---@enum EB1CityGraphLaneLinkQueryFlag
local EB1CityGraphLaneLinkQueryFlag = {
    Invalid = 0,
    Self = 1,
    Parallel = 2,
    Converging = 3,
    Separating = 4,
    AfterSeparating = 5,
    EB1CityGraphLaneLinkQueryFlag_MAX = 6,
}

---@enum EB1CityGraphLaneLinkType
local EB1CityGraphLaneLinkType = {
    Invalid = 0,
    None = 1,
    Incomming = 2,
    Outgoing = 3,
    Adjacency = 4,
    EB1CityGraphLaneLinkType_MAX = 5,
}

---@enum EB1CityGraphLaneState
local EB1CityGraphLaneState = {
    InValid = 0,
    Open = 1,
    SoftClosed = 2,
    HardClosed = 3,
    EB1CityGraphLaneState_MAX = 4,
}

---@enum EB1CityGraphRoadLinkType
local EB1CityGraphRoadLinkType = {
    Invalid = 0,
    Incoming = 1,
    Outgoing = 2,
    Merging = 3,
    Diverging = 4,
    EB1CityGraphRoadLinkType_MAX = 5,
}

---@enum EB1CleanlinessLevelConditionType
local EB1CleanlinessLevelConditionType = {
    Range = 0,
    Single = 1,
    EB1CleanlinessLevelConditionType_MAX = 2,
}

---@enum EB1CollectAutonomyResult
local EB1CollectAutonomyResult = {
    Invalid = 0,
    Success = 1,
    Fail = 2,
    EB1CollectAutonomyResult_MAX = 3,
}

---@enum EB1CompareType
local EB1CompareType = {
    None = 0,
    Equal = 1,
    NotEqual = 2,
    Greater = 3,
    Less = 4,
    GreaterOrEqual = 5,
    LessOrEqual = 6,
    EB1CompareType_MAX = 7,
}

---@enum EB1ConditionType
local EB1ConditionType = {
    Invalid = 0,
    None = 1,
    Fail = 2,
    Stat = 3,
    ObjectCategory = 4,
    HandCarriedObjectType = 5,
    HandCarriedObjectId = 6,
    HandCarriedObjectTag = 7,
    HasCarriedObject = 8,
    HasObjectTag = 9,
    HasFood = 10,
    Buff = 11,
    BuffTag = 12,
    Posture = 13,
    State = 14,
    Emotion = 15,
    EmotionValue = 16,
    EmotionLevel = 17,
    OwnedEmotionLevel = 18,
    EmotionTendency = 19,
    Skill = 20,
    SkillUp = 21,
    RelationshipStat = 22,
    RelationshipStatRange = 23,
    RelationshipName = 24,
    HasRelationship = 25,
    HasRelationshipName = 26,
    IsRelationshipFocusSelection = 27,
    InteractionName = 28,
    InteractionTag = 29,
    InteractionBagTag = 30,
    Trait = 31,
    TargetDistance = 32,
    NumberOfZOI = 33,
    InteractionObjectRange = 34,
    InteractionTargetIsOwner = 35,
    GrowthStep = 36,
    IsChildAllowedInWorld = 37,
    CanPregnancy = 38,
    CanMarry = 39,
    CanMarrySuccess = 40,
    OccupyingSlotByPosture = 41,
    OccupyingConnectedChairByPosture = 42,
    Gender = 43,
    GenderCompWithTarget = 44,
    ActionTimeId = 45,
    ActionTimeTag = 46,
    CompleteHope = 47,
    CompleteAmbition = 48,
    PlayingAmbition = 49,
    CurrentAmbition = 50,
    HasJob = 51,
    ComparePreviousJobRank = 52,
    IsWorking = 53,
    HasHome = 54,
    IsLocatedSameSite = 55,
    Site = 56,
    SiteByImpactPoint = 57,
    Time = 58,
    TimeRange = 59,
    Costume = 60,
    OutfitCategory = 61,
    OutfitGarmentTag = 62,
    HasOutfitGarmentType = 63,
    HasOutfitAccessoryType = 64,
    DayOfTheWeek = 65,
    IsWeekday = 66,
    IsWeekend = 67,
    IsFamilyRelationship = 68,
    HasFamilyRelationship = 69,
    IsNumberOfRelatives = 70,
    IsFamilyAgeRank = 71,
    IsFullFamilyMembers = 72,
    IsHouseMate = 73,
    JobEmploymentDay = 74,
    JobRank = 75,
    JobRankCompWithTarget = 76,
    IsSiteScheduleNPC = 77,
    EnteredSiteType = 78,
    IsHome = 79,
    IsPlayerFamily = 80,
    IsPlayerFamilyTree = 81,
    IsPlayerFamilyAndFamilyTree = 82,
    IsPlayerFamilyOrFamilyTree = 83,
    IsPlayerCharacter = 84,
    IsPlayerCharacterSelfOrTarget = 85,
    IsNpcCharacter = 86,
    IsCharacterRole = 87,
    HasPreference = 88,
    IsPreferenceLike = 89,
    RelationshipFamilyLove = 90,
    HasRelationshipFamilyLove = 91,
    IsVisitingFriend = 92,
    HasOverrideTimeline = 93,
    IsGiftBoxOwner = 94,
    GiftBoxTendency = 95,
    DustyValue = 96,
    IsInVehicle = 97,
    IsVehicle = 98,
    IsVehicleInAutoDriving = 99,
    IsDriver = 100,
    IsVehicleDriving = 101,
    IsVehicleSeatOccupied = 102,
    IsAnyVehicleSeatOccupied = 103,
    IsVehicleLightsOn = 104,
    IsWaitingForPassenger = 105,
    IsOwnedVehicle = 106,
    VehicleSpeed = 107,
    HasOwnedVehicle = 108,
    IsVehicleInParkingPlace = 109,
    IsReachableUsingVehicle = 110,
    IsIndoor = 111,
    IsChangeableState = 112,
    City = 113,
    NearestCityGraphPointDistance = 114,
    IsSiteHasObjectTemplateTag = 115,
    IsCompanyEmployee = 116,
    CheckHowlingTaken = 117,
    OwnedVehicleSpawned = 118,
    VehiclePartState = 119,
    IsOwnerSitInDriverSeat = 120,
    CharacterGroupType = 121,
    IsCarriableObject = 122,
    ObjectSize = 123,
    MainPerspective = 124,
    PerspectivePoint = 125,
    PerspectivePointDiff = 126,
    IsWorkingDayOfWeek = 127,
    WithinJob = 128,
    HasJobType = 129,
    ForTimeSite = 130,
    HaveCurrency = 131,
    SiteCleanliness = 132,
    HomeCleanliness = 133,
    EnteredSiteHasTag = 134,
    Season = 135,
    Weather = 136,
    TemperatureRange = 137,
    IsInInventory = 138,
    HasEntityTag = 139,
    IsLocateSiteInBaby = 140,
    IsLocateSiteOnFire = 141,
    HasRumor = 142,
    IsSameRumor = 143,
    HasRumorValidIndex = 144,
    HasSameRumorInIndex = 145,
    CanRumorTransfer = 146,
    IsGhostCharacter = 147,
    RomanticOrientation = 148,
    IsMatchingRomanceTarget = 149,
    IsInSiteWithInTime = 150,
    HasPutableObjectOnHand = 151,
    IsSiteOnFire = 152,
    CanBecomeGhost = 153,
    IsProfileLocked = 154,
    HasEnoughCurrency = 155,
    HasTaxId = 156,
    IsForceableSale = 157,
    IsSeized = 158,
    IsElectricityCutoffSite = 159,
    IsWaterCutoffSite = 160,
    IsCrafting = 161,
    HasObjectInCraftingSlot = 162,
    IsObjectAuthor = 163,
    CraftingPlaySuccessAnimation = 164,
    CraftingPlayIdleAnimation = 165,
    Quality = 166,
    RelationshipDeviation = 167,
    HasSalesRights = 168,
    HasEnoughCurrencyTarget = 169,
    HasEnoughCurrencyExchangeCost = 170,
    HasEnoughCurrencyExchangeCostInSite = 171,
    IsPlayingSiteEvent = 172,
    IsSiteEventRole = 173,
    IsGraduationRank = 174,
    IsSameSite = 175,
    IsSameSiteEvent = 176,
    IsSameSiteEventRole = 177,
    CanAddObjectToBag = 178,
    CanAddObjectTemplateToBag = 179,
    CanRemoveObjectToBag = 180,
    CanRemoveObjectTemplateToBag = 181,
    IsInSameFamilyTree = 182,
    IsFamilyHead = 183,
    ObjectPrice = 184,
    HasGeneratedMotionIndex = 185,
    EnableGenerateMotion = 186,
    GiftType = 187,
    CheckGhostInteractionReason = 188,
    HasCeiling = 189,
    HasCeilingByImpactPoint = 190,
    HasFloor = 191,
    HasFloorByImpactPoint = 192,
    ObjectWeathering = 193,
    IsBabyBeingHeld = 194,
    PurchaseSuccessBaseOnPrice = 195,
    StealSuccessBaseOnPrice = 196,
    IsPurchasable = 197,
    HasOverrideSkin = 198,
    HasOverrideSkinColor = 199,
    EB1ConditionType_MAX = 200,
}

---@enum EB1CoopCharacterState
local EB1CoopCharacterState = {
    Invalid = 0,
    Ready = 1,
    Execute = 2,
    Loop = 3,
    Waiting = 4,
    Cancel = 5,
    Released = 6,
    EB1CoopCharacterState_MAX = 7,
}

---@enum EB1CoopPhase
local EB1CoopPhase = {
    Invalid = 0,
    Setup = 1,
    Recruit = 2,
    Task = 3,
    Release = 4,
    EB1CoopPhase_MAX = 5,
}

---@enum EB1CoopResult
local EB1CoopResult = {
    None = 0,
    FailedBeginCoop = 1,
    PlayingCoop = 2,
    OwnerPlayingCoop = 3,
    TargetPlayingCoop = 4,
    Sleepwalking = 5,
    OwnerSleepwalking = 6,
    TargetSleepwalking = 7,
    TargetSleeping = 8,
    TimeOut = 9,
    NotEnoughTarget = 10,
    NotEnoughCharacter = 11,
    NotEnoughVehicleSeat = 12,
    FailedInteraction = 13,
    CharacterCanceled = 14,
    RequestLeaveCoop = 15,
    InvalidTask = 16,
    CannotFindSpace = 17,
    FailedAddInteractionQueue = 18,
    FailedSelectRandomAnim = 19,
    HostCanceledCoop = 20,
    Rescue = 21,
    FailedFindVehicle = 22,
    NotEnoughAvailablePassengerSlots = 23,
    InvalidCharacter = 24,
    InvalidDriver = 25,
    CurrentInteractionIsNeverInterrupted = 26,
    CurrentInteractionIsNonCancelable = 27,
    TargetIsFar = 28,
    NotEqualTalkLocationCount = 29,
    CarryingCharacter = 30,
    Carried = 31,
    FailedRequestTalk = 32,
    Success = 33,
    EB1CoopResult_MAX = 34,
}

---@enum EB1CoopType
local EB1CoopType = {
    Invalid = 0,
    None = 1,
    MoveTogether = 2,
    EnterVehicle = 3,
    Coop = 4,
    CoopTalk = 5,
    Talk = 6,
    EB1CoopType_MAX = 7,
}

---@enum EB1CraftObjectSpawnPoint
local EB1CraftObjectSpawnPoint = {
    None = 0,
    RightHand = 1,
    CraftingSlot = 2,
    Inventory = 3,
    EB1CraftObjectSpawnPoint_MAX = 4,
}

---@enum EB1CraftingFinalObjectType
local EB1CraftingFinalObjectType = {
    None = 0,
    Food = 1,
    EB1CraftingFinalObjectType_MAX = 2,
}

---@enum EB1CraftingIngredientSearchType
local EB1CraftingIngredientSearchType = {
    None = 0,
    Inventory = 1,
    TargetFilter = 2,
    SkillCheck = 3,
    EB1CraftingIngredientSearchType_MAX = 4,
}

---@enum EB1DataLayerType
local EB1DataLayerType = {
    Invalid = 0,
    HideMapMode = 1,
    ShowMapMode = 2,
    Ocean = 3,
    EB1DataLayerType_MAX = 4,
}

---@enum EB1DayOfWeek
local EB1DayOfWeek = {
    Monday = 0,
    Tuesday = 1,
    Wednesday = 2,
    Thursday = 3,
    Friday = 4,
    Saturday = 5,
    Sunday = 6,
    Invalid = 7,
    EB1DayOfWeek_MAX = 8,
}

---@enum EB1DebugCharacter
local EB1DebugCharacter = {
    Basic = 0,
    Components = 1,
    Age = 2,
    Buff = 3,
    EntityTag = 4,
    Trait = 5,
    Interaction = 6,
    Inventory = 7,
    Anim = 8,
    Job = 9,
    Voice = 10,
    Emotion = 11,
    Stat = 12,
    Schedule = 13,
    Relationship = 14,
    Skill = 15,
    Dream = 16,
    Ambition = 17,
    Hope = 18,
    Perspective = 19,
    LifeTrigger = 20,
    Rumor = 21,
    Stuck = 22,
    Space = 23,
    RabbitHole = 24,
    SlotOwnership = 25,
    SLM = 26,
    Ghost = 27,
    Talk = 28,
    Preference = 29,
    Appearance = 30,
    MAX = 31,
}

---@enum EB1DebugGameObject
local EB1DebugGameObject = {
    Basic = 0,
    Door = 1,
    Slot = 2,
    Stat = 3,
    EntityTag = 4,
    Anim = 5,
    ObjectWeathering = 6,
    Craft = 7,
    Creation = 8,
    MAX = 9,
}

---@enum EB1DiversityCity
local EB1DiversityCity = {
    Invalid = 0,
    Dowon = 1,
    Blissbay = 2,
    Max = 3,
}

---@enum EB1DiversityCulture
local EB1DiversityCulture = {
    Invalid = 0,
    NorthAmerica = 1,
    Korea = 2,
    Japan = 3,
    China = 4,
    EB1DiversityCulture_MAX = 5,
}

---@enum EB1DiversityRace
local EB1DiversityRace = {
    Invalid = 0,
    Caucasian = 1,
    AfricanAmerican = 2,
    LatinAmerican = 3,
    EastAsian = 4,
    EB1DiversityRace_MAX = 5,
}

---@enum EB1DoorAnimationType
local EB1DoorAnimationType = {
    HingedDoor = 0,
    SlidingDoor = 1,
    Garage = 2,
    EB1DoorAnimationType_MAX = 3,
}

---@enum EB1DoorPermissionCheckFailReason
local EB1DoorPermissionCheckFailReason = {
    None = 0,
    FailDeveloperPermission = 1,
    FailUserPermission = 2,
    OwnerlessResidenceDoor = 3,
    EB1DoorPermissionCheckFailReason_MAX = 4,
}

---@enum EB1DoorPermissionGroup
local EB1DoorPermissionGroup = {
    All = 0,
    Nobody = 1,
    Family = 2,
    Me = 3,
    Relationship = 4,
    Company = 5,
    Male = 6,
    Female = 7,
    Invalid = 8,
    EB1DoorPermissionGroup_MAX = 9,
}

---@enum EB1DoorPermissionMode
local EB1DoorPermissionMode = {
    User = 0,
    BuildMode = 1,
    EB1DoorPermissionMode_MAX = 2,
}

---@enum EB1DreamType
local EB1DreamType = {
    Invalid = 0,
    REM = 1,
    Sleepwalking = 2,
    EB1DreamType_MAX = 3,
}

---@enum EB1EducationType
local EB1EducationType = {
    Invalid = 0,
    Elementary = 1,
    Middle = 2,
    High = 3,
    College = 4,
    Max = 5,
}

---@enum EB1EmotionTendency
local EB1EmotionTendency = {
    Invalid = 0,
    Natural = 1,
    Positive = 2,
    Negative = 3,
    Max = 4,
}

---@enum EB1EmotionType
local EB1EmotionType = {
    None = 0,
    Normal = 1,
    Sleep = 2,
    Preoccupied = 3,
    Curious = 4,
    Convinced = 5,
    Excited = 6,
    Enchanting = 7,
    Funny = 8,
    Calm = 9,
    Touched = 10,
    Surprised = 11,
    Bored = 12,
    Tired = 13,
    Sad = 14,
    Uncomfortable = 15,
    Uneasy = 16,
    Cringing = 17,
    Irritated = 18,
    Worried = 19,
    EB1EmotionType_MAX = 20,
}

---@enum EB1EmploymentForm
local EB1EmploymentForm = {
    Invalid = 0,
    None = 1,
    FullTime = 2,
    PartTime = 3,
    Freelancer = 4,
    EB1EmploymentForm_MAX = 5,
}

---@enum EB1ExecuteType
local EB1ExecuteType = {
    Invalid = 0,
    None = 1,
    AddBuff = 2,
    RemoveBuff = 3,
    AddRandomBuff = 4,
    RemoveBuffTag = 5,
    AddStat = 6,
    RemoveStat = 7,
    ChangeState = 8,
    RemoveState = 9,
    ChangeStateAllInSite = 10,
    ChangeStateInRange = 11,
    AddRelationship = 12,
    AddRelationshipName = 13,
    RemoveRelationshipName = 14,
    Marriage = 15,
    Divorce = 16,
    ReleaseRelationshipFocus = 17,
    AddSkillExp = 18,
    SpawnNewCarriableObject = 19,
    SpawnNewBookObject = 20,
    SpawnNewFoodObject = 21,
    SpawnNewCraftObject = 22,
    DestroyCarriableObject = 23,
    DestroyCraftObject = 24,
    SetCraftObjectVisibility = 25,
    AddCraftingProgress = 26,
    PickUpServedFoodObject = 27,
    PickUpAttachObject = 28,
    PutDownDetachObject = 29,
    PickUpSlotObject = 30,
    PickUpAttachCharacter = 31,
    PutDownDetachCharacter = 32,
    AddModifier = 33,
    RemoveModifier = 34,
    AddCurrency = 35,
    SetCurrency = 36,
    AddCurrencyRange = 37,
    ExchangeCurrency = 38,
    PayForObjectExchange = 39,
    PayForObjectExchangeInSite = 40,
    RunScriptToTargetInSite = 41,
    SystemMessage = 42,
    PopupMessage = 43,
    AddLifeTrigger = 44,
    RemoveLifeTrigger = 45,
    Death = 46,
    Pregnancy = 47,
    ChildBirth = 48,
    AddHowling = 49,
    RemoveHowling = 50,
    AddSpeechBubble = 51,
    RemoveSpeechBubble = 52,
    AddTransientDesireStat = 53,
    RemoveTransientDesireStat = 54,
    ChangeAdmitDesireBoost = 55,
    ChangeJoyfulDesireBoost = 56,
    ChangeJobRank = 57,
    PregnancyBodyMorph = 58,
    ChangeOutfit = 59,
    RemoveOutfit = 60,
    RemoveOutfitByCostumeTag = 61,
    ChangeOutfitCategory = 62,
    RemoveOutfitCategory = 63,
    ChangeBaseOutfitCategory = 64,
    ChangeObjectWeathering = 65,
    OpenUI = 66,
    EnableSprint = 67,
    DisableSprint = 68,
    SetDataLayerState = 69,
    SetClothWeatheringIntensity = 70,
    ApplyOverrideTimeline = 71,
    ApplyOverrideTimelineTargetSite = 72,
    RemoveOverrideTimeline = 73,
    AttachMesh = 74,
    DetachMesh = 75,
    SendVisitMessage = 76,
    EndCurrentSchedule = 77,
    MakeRabbitHoleRelationship = 78,
    AddRabbitHoleRelationship = 79,
    CustomMobileMessage = 80,
    CustomMobileMessageForMeetNow = 81,
    CustomMobileMessageForMeetWithTimeline = 82,
    CustomMessagePlainText = 83,
    OpenGiftBox = 84,
    SendGiftBox = 85,
    CharacterArrivedPopup = 86,
    CleanDusty = 87,
    PlayFX = 88,
    PlayPP = 89,
    PlaySound2D = 90,
    StartDream = 91,
    EndDream = 92,
    EndSleepwalking = 93,
    ShowDreamBubble = 94,
    HideDreamBubble = 95,
    ChangeInteractionPickedActor = 96,
    SpawnGameObject = 97,
    SubActionPlayAnim = 98,
    CancelInteractionBagByTag = 99,
    ApplyOneTimePostureAnim = 100,
    CancelOneTimePostureAnim = 101,
    ReturnToParkingPlace = 102,
    FreezeVehicle = 103,
    UnfreezeVehicle = 104,
    PutInventoryCarriableObject = 105,
    PutDownInventoryObject = 106,
    AddPerspective = 107,
    FireExtinguish = 108,
    AddEntityTag = 109,
    RemoveEntityTag = 110,
    MakeRumor = 111,
    RumorEvent = 112,
    RumorTransfer = 113,
    RumorTransferByIndex = 114,
    DespawnGameObject = 115,
    RequestService = 116,
    AddJobExp = 117,
    ProfileUnlock = 118,
    RelationshipTalkRecord = 119,
    PayTax = 120,
    AddServiceUsage = 121,
    AddSeizure = 122,
    ForcedSale = 123,
    AddQuest = 124,
    RemoveQuest = 125,
    SetInvisible = 126,
    PutInInventory = 127,
    PutInSiteInventory = 128,
    BuyTargetObject = 129,
    SetDoorPrivilege = 130,
    SpawnFakeObject = 131,
    OpenChoiceCardPopup = 132,
    AddObjectToBag = 133,
    AddObjectTemplateToBag = 134,
    RemoveObjectInBag = 135,
    RemoveObjectTemplateInBag = 136,
    SetGhostInteractionAvailability = 137,
    SetWorldGhostVisibility = 138,
    PocketMarketRemoveSellingItem = 139,
    ModifyTemporaryAppearance = 140,
    ModifyTemporaryAppearanceHair = 141,
    RevertTemporaryAppearance = 142,
    AllRevertTemporaryAppearance = 143,
    AddFamilyMonitoringNotification = 144,
    FinishService = 145,
    CreateSiteEvent = 146,
    FinishSiteEvent = 147,
    OpenCreateSocialEventPopup = 148,
    OpenCommonBox = 149,
    SetMeshToSpawner = 150,
    CacheTemporaryMeshId = 151,
    AttachGrabObject = 152,
    DetachGrabObject = 153,
    ToastMessage = 154,
    TakePicture = 155,
    PocketMarketSellingItemSold = 156,
    ApplyOverrideSkin = 157,
    ApplyOverrideSkinColor = 158,
    EB1ExecuteType_MAX = 159,
}

---@enum EB1ExportSiteDataOption
local EB1ExportSiteDataOption = {
    None = 0,
    SkipCompanyRoleNPC = 1,
    SkipScheduledRoleNPC = 2,
    SkipCrowdNPC = 4,
    ALL = 255,
    EB1ExportSiteDataOption_MAX = 256,
}

---@enum EB1ExtensionSelect
local EB1ExtensionSelect = {
    B1 = 0,
    B2 = 1,
    Thumbnail = 2,
    Bin = 3,
    Json = 4,
    B1Cbor = 5,
    B2Cbor = 6,
    B1Cbor_Temp = 7,
    B2Cbor_Temp = 8,
    Thumbnail_Temp = 9,
    EB1ExtensionSelect_MAX = 10,
}

---@enum EB1FaceAxisFlag
local EB1FaceAxisFlag = {
    Invalid = 0,
    X = 1,
    Y = 2,
    Z = 4,
    XY = 3,
    YZ = 6,
    ZX = 5,
    XYZ = 7,
    InvX = 8,
    InvY = 16,
    InvZ = 32,
    EB1FaceAxisFlag_MAX = 33,
}

---@enum EB1FaceHairType
local EB1FaceHairType = {
    Eyebrow = 0,
    Eyelash = 1,
    Mustache = 2,
    Beard = 3,
    MAX = 255,
}

---@enum EB1FaceMakeUpType
local EB1FaceMakeUpType = {
    Iris = 0,
    Eyeshadow = 1,
    Eyeline = 2,
    Cheek = 3,
    Lip = 4,
    MAX = 255,
}

---@enum EB1FaceTransformType
local EB1FaceTransformType = {
    Translate = 0,
    Scale = 1,
    Rotate = 2,
    MAX = 3,
}

---@enum EB1FacialExpressionReason
local EB1FacialExpressionReason = {
    Invalid = 0,
    Emotion = 1,
    Interaction = 2,
    EB1FacialExpressionReason_MAX = 3,
}

---@enum EB1FamilyCreateBornRegionControllType
local EB1FamilyCreateBornRegionControllType = {
    Random = 0,
    Equal = 1,
    Korea = 2,
    Japan = 3,
    China = 4,
    America = 5,
    African = 6,
    Num = 7,
    EB1FamilyCreateBornRegionControllType_MAX = 8,
}

---@enum EB1FamilyCreateGenderControllType
local EB1FamilyCreateGenderControllType = {
    Random = 0,
    Equal = 1,
    NotEqual = 2,
    Male = 3,
    Female = 4,
    Num = 5,
    EB1FamilyCreateGenderControllType_MAX = 6,
}

---@enum EB1FamilyMoveFamilyOption
local EB1FamilyMoveFamilyOption = {
    ObjectSave = 0,
    ObjectSell = 1,
    EB1FamilyMoveFamilyOption_MAX = 2,
}

---@enum EB1FamilyMoveSiteOption
local EB1FamilyMoveSiteOption = {
    ObjectPreserve = 0,
    ObjectEmpty = 1,
    SiteClear = 2,
    EB1FamilyMoveSiteOption_MAX = 3,
}

---@enum EB1FamilyRelationshipType
local EB1FamilyRelationshipType = {
    None = 0,
    Base = 1,
    Spouse = 2,
    Parent = 3,
    Sibling = 4,
    Child = 5,
    GrandParent = 6,
    GrandChild = 7,
    Uncle = 8,
    Aunt = 9,
    Nephew = 10,
    Cousin = 11,
    SisterInLaw = 12,
    BrotherInLaw = 13,
    Ancestor = 14,
    Descendant = 15,
    Num = 16,
    EB1FamilyRelationshipType_MAX = 17,
}

---@enum EB1FamilySelectEntryType
local EB1FamilySelectEntryType = {
    Family = 0,
    DeleteFamily = 1,
    NewFamily = 2,
    AddCanvas = 3,
    BlankFamily = 4,
    EB1FamilySelectEntryType_MAX = 5,
}

---@enum EB1FeedbackTarget
local EB1FeedbackTarget = {
    Prev = 0,
    Current = 1,
    Picked = 2,
    EB1FeedbackTarget_MAX = 3,
}

---@enum EB1FilterResultType
local EB1FilterResultType = {
    Invalid = 0,
    NearTarget = 1,
    FarTarget = 2,
    TargetList = 3,
    EB1FilterResultType_MAX = 4,
}

---@enum EB1FilterType
local EB1FilterType = {
    Realistic = 0,
    Cartoon = 1,
    TiltedShift = 2,
    BW2Color = 3,
    X4Pixels = 4,
    LensEffectA = 5,
    Draw = 6,
    GradientBand = 7,
    LensEffectB = 8,
    Realistic_Row = 9,
    EB1FilterType_MAX = 10,
}

---@enum EB1FollowingType
local EB1FollowingType = {
    Invalid = 0,
    CameraViewTarget = 1,
    Actor = 2,
    Location = 3,
    EB1FollowingType_MAX = 4,
}

---@enum EB1FoodType
local EB1FoodType = {
    PreparedFood = 0,
    ServedFood = 1,
    EB1FoodType_MAX = 2,
}

---@enum EB1FootType
local EB1FootType = {
    Flat = 0,
    HighHeel = 1,
    Default = 0,
    LAST = 1,
    EB1FootType_MAX = 2,
}

---@enum EB1GameObjectAttachSocketType
local EB1GameObjectAttachSocketType = {
    Invalid = 0,
    RightHand_Socket = 1,
    LeftHand_Socket = 2,
    Head_Socket = 3,
    EB1GameObjectAttachSocketType_MAX = 4,
}

---@enum EB1GameOption
local EB1GameOption = {
    None = 0,
    Display = 1,
    Resolution = 2,
    Monitor = 3,
    Benchmark = 4,
    Preset = 5,
    ViewDistance = 6,
    CharacterViewDistance = 7,
    LightViewDistance = 8,
    AntiAliasingMethod = 9,
    AntiAliasingQuality = 10,
    PostProcessQuality = 11,
    ShadowQuality = 12,
    GlobalIlluminationQuality = 13,
    ReflectionQuality = 14,
    TextureQuality = 15,
    EffectsQuality = 16,
    FoliageQuality = 17,
    ShadingQuality = 18,
    RayTracingQuality = 19,
    MeshQuality = 20,
    ClothSimulation = 21,
    FOV = 22,
    Brightness = 23,
    MotionBlur = 24,
    DepthOfField = 25,
    MassVehicleDensity = 26,
    AnimationBudget = 27,
    FollowViewMouseSensitivity = 28,
    FollowViewWheelSpeed = 29,
    TopViewWheelSpeed = 30,
    MouseCursorEdgeScrollDisable = 31,
    RomanKeyboardLayout = 32,
    Language = 33,
    MasterSoundVolume = 34,
    MusicSoundVolume = 35,
    SFXSoundVolume = 36,
    UISoundVolume = 37,
    VoiceSoundVolume = 38,
    CinematicsSoundVolume = 39,
    Autonomy = 40,
    ScreenPercentage = 41,
    DynamicResolution = 42,
    DynamicResolutionTargetFrame = 43,
    DLSS = 44,
    DLSSG = 45,
    FSR3 = 46,
    FSR3FI = 47,
    MetalFX = 48,
    XeSS = 49,
    MaxFPS = 50,
    NightExposureBias = 51,
    UsePopupCloseCooltime = 52,
    CharacterNameFormat = 53,
    VSync = 54,
    RayTracingMethod = 55,
    ClearPSOCache = 56,
    OcclusionMethod = 57,
    GameObjectCastShadows = 58,
    RayTracingNaniteQuality = 59,
    EnableAutoSave = 60,
    AutoSaveInterval = 61,
    Mod = 62,
    ModEnable = 63,
    ShowModList = 64,
    SetDayLength = 65,
    ShowModkitAssetList = 66,
    KCN = 67,
    SmartZoi = 68,
    SmartZoiRangeInCity = 69,
    SmartZoiRangeInViewport = 70,
    SmartZoiAutonomy = 71,
    SmartZoiWaitingCount = 72,
    VehicleManualDrivingActive = 73,
    Temperature = 74,
    Version = 75,
    Licenses = 76,
    UserId = 77,
    EB1GameOption_MAX = 78,
}

---@enum EB1GameOptionUIType
local EB1GameOptionUIType = {
    Arrow = 0,
    Slider = 1,
    Button = 2,
    Dropdown = 3,
    CheckBox = 4,
    ClearPSOCacheButton = 5,
    BenchmarkButton = 6,
    ModListButton = 7,
    ModKitListButton = 8,
    KCNButton = 9,
    TextBlock = 10,
    LicensesButton = 11,
    TextCopy = 12,
    EB1GameOptionUIType_MAX = 13,
}

---@enum EB1GarmentCoveringRegion
local EB1GarmentCoveringRegion = {
    None = 0,
    LeftShoulder = 1,
    RightShoulder = 2,
    LeftArmUpper = 4,
    RightArmUpper = 8,
    LeftArmLower = 16,
    RightArmLower = 32,
    LeftSide = 64,
    RightSide = 128,
    Chest = 256,
    Back = 512,
    BellyUpper = 1024,
    BellyLower = 2048,
    WaistBack = 4096,
    Buttocks = 8192,
    LeftThigh = 16384,
    RightThigh = 32768,
    LeftShin = 65536,
    RightShin = 131072,
    LeftAnkle = 262144,
    RightAnkle = 524288,
    LeftFoot = 1048576,
    RightFoot = 2097152,
    LeftHand = 4194304,
    RightHand = 8388608,
    NeckFront = 16777216,
    NeckBack = 33554432,
    PantsWaist = 67108864,
    NeckTight = 134217728,
    LeftAnkleLow = 268435456,
    RightAnkleLow = 536870912,
    MAX = 1073741823,
    LeftArmShort = 5,
    RightArmShort = 10,
    LeftArm = 21,
    RightArm = 42,
    Shoulders = 3,
    ArmsAll = 63,
    ArmsAllShort = 15,
    Gloves = 12582912,
    UpperBodyShort = 704,
    UpperBodyShortClosed = 960,
    UpperBody = 4800,
    UpperBodyClosed = 6080,
    Waist = 5120,
    BackBody = 4608,
    BackAndArms = 575,
    LeftLeg = 81920,
    RightLeg = 163840,
    BottomShort = 10240,
    BottomMid = 59392,
    BottomLong = 256000,
    Shoes = 3145728,
    SocksShort = 3145728,
    SocksMid = 3932160,
    SocksLong = 4128768,
    WholeBody = 16777215,
}

---@enum EB1GarmentType
local EB1GarmentType = {
    None = 0,
    Top = 1,
    Bottom = 2,
    Full = 3,
    Shoes = 4,
    Jacket = 5,
    Hat = 6,
    Socks = 7,
    InnerTop = 8,
    InnerUnder = 9,
    Necklace = 10,
    Nail = 11,
    Bracelet = 12,
    Ring = 13,
    MAX = 255,
}

---@enum EB1GenderIdentity
local EB1GenderIdentity = {
    Invalid = 0,
    Male = 1,
    Female = 2,
    NonBinary = 3,
    EB1GenderIdentity_MAX = 4,
}

---@enum EB1GenderType
local EB1GenderType = {
    Invalid = 0,
    Default = 1,
    Female = 2,
    Male = 3,
    EB1GenderType_MAX = 4,
}

---@enum EB1GiftType
local EB1GiftType = {
    None = 0,
    Common = 1,
    Relationship = 2,
    EB1GiftType_MAX = 3,
}

---@enum EB1GizmoAxisType
local EB1GizmoAxisType = {
    None = 0,
    X = 1,
    Y = 2,
    Z = 4,
    EB1GizmoAxisType_MAX = 5,
}

---@enum EB1GizmoTransformType
local EB1GizmoTransformType = {
    None = 0,
    Location = 1,
    Rotation = 2,
    Scale = 3,
    FreeMove = 4,
    EB1GizmoTransformType_MAX = 5,
}

---@enum EB1GrabType
local EB1GrabType = {
    PickUp = 0,
    PutDown = 1,
    EB1GrabType_MAX = 2,
}

---@enum EB1GraphicsPreset
local EB1GraphicsPreset = {
    Custom = -1,
    VeryLow = 0,
    Low = 1,
    Normal = 2,
    High = 3,
    Cinematic = 4,
    Num = 5,
    EB1GraphicsPreset_MAX = 6,
}

---@enum EB1GridState
local EB1GridState = {
    Unset = 0,
    None = 1,
    Used = 2,
    Unusable = 3,
    Isolated = 4,
    DoorRange = 5,
    EB1GridState_MAX = 6,
}

---@enum EB1GrowthChangeClassType
local EB1GrowthChangeClassType = {
    None = 0,
    Trait = 1,
    Preference = 2,
    Ambition = 3,
    Stat = 4,
    Life = 5,
    EB1GrowthChangeClassType_MAX = 6,
}

---@enum EB1GrowthStep
local EB1GrowthStep = {
    Invalid = 0,
    Infant = 1,
    Toddler = 2,
    Child = 4,
    LowTeen = 8,
    HighTeen = 16,
    Youth = 32,
    Adult = 64,
    Old = 128,
    Elderly = 256,
    MAX = 512,
    Baby = 3,
    OverOld = 384,
    OverAdult = 448,
    OverYouth = 480,
    OverHighTeen = 496,
    OverLowTeen = 504,
    OverChild = 508,
    All = 511,
}

---@enum EB1HairLengthType
local EB1HairLengthType = {
    None = 0,
    Long = 1,
    Medium = 2,
    Short = 3,
    MAX = 4,
}

---@enum EB1HairType
local EB1HairType = {
    None = 0,
    Straight = 1,
    Wavy = 2,
    Curly = 3,
    Bald = 4,
    MAX = 5,
}

---@enum EB1HandType
local EB1HandType = {
    LeftHand = 0,
    RightHand = 1,
    EB1HandType_MAX = 2,
}

---@enum EB1HatType
local EB1HatType = {
    Default = 0,
    BallCap = 1,
    Fedora = 2,
    Beanie = 3,
    Helmet = 4,
    Durag = 5,
    MAX = 6,
}

---@enum EB1HouseholdEditMode
local EB1HouseholdEditMode = {
    Default = 0,
    Move = 1,
    Delete = 2,
    EB1HouseholdEditMode_MAX = 3,
}

---@enum EB1HouseholdMoveMode
local EB1HouseholdMoveMode = {
    FamilyMove = 0,
    Marriage = 1,
    NewHouse = 2,
    Divorce = 3,
    EB1HouseholdMoveMode_MAX = 4,
}

---@enum EB1HouseholdMoveObjectSaveResponseType
local EB1HouseholdMoveObjectSaveResponseType = {
    Invalid = 0,
    CanSaveButSell = 1,
    CanSave = 2,
    EB1HouseholdMoveObjectSaveResponseType_MAX = 3,
}

---@enum EB1HouseholdWidgetMode
local EB1HouseholdWidgetMode = {
    Default = 0,
    Create = 1,
    InGameCreate = 2,
    Edit = 3,
    EB1HouseholdWidgetMode_MAX = 4,
}

---@enum EB1HowlingEmitterType
local EB1HowlingEmitterType = {
    Base = 0,
    VehicleAccident = 1,
    Trend = 2,
    Invalid = 3,
    EB1HowlingEmitterType_MAX = 4,
}

---@enum EB1HowlingFrequencyType
local EB1HowlingFrequencyType = {
    OneTime = 0,
    Enter = 1,
    Pulse = 2,
    EB1HowlingFrequencyType_MAX = 3,
}

---@enum EB1InputCommandType
local EB1InputCommandType = {
    None = 0,
    TimeScale = 1,
    ToggleTimeScale = 2,
    PossessAnotherFamily = 3,
    Upstairs = 4,
    Downstairs = 5,
    ToggleUI = 6,
    ToggleOperatorWidget = 7,
    ToggleSmartPhoneWidget = 8,
    ToggleRelationshipWidget = 9,
    ToggleAutonomy = 10,
    TopViewFocus = 11,
    ToggleBuildMode = 12,
    UndoAction = 13,
    RedoAction = 14,
    ToggleGridMode = 15,
    PreviousWallMode = 16,
    NextWallMode = 17,
    SelectMode = 18,
    RoomSelectMode = 19,
    EB1InputCommandType_MAX = 20,
}

---@enum EB1InputMappingContextType
local EB1InputMappingContextType = {
    General = 0,
    EB1InputMappingContextType_MAX = 1,
}

---@enum EB1InteractionCancelReason
local EB1InteractionCancelReason = {
    None = 0,
    Clear = 1,
    LifeTrigger = 2,
    OnFailedWalkToTarget = 3,
    InvalidAction = 4,
    InvalidCity = 5,
    InvalidSelfEntity = 6,
    InvalidSelfLocation = 7,
    InvalidTargetLocation = 8,
    InvalidTargetSlot = 9,
    InvalidSite = 10,
    InvalidWalkToSitePoint = 11,
    InvalidData = 12,
    InvalidSystem = 13,
    FailedFindPath = 14,
    FailedParseCoopContext = 15,
    FailedSelectInteractionIndex = 16,
    FailedFindTargetLocation = 17,
    FailedFindNearGridLocation = 18,
    FailedFindNearestOutlineLocation = 19,
    FailedFindNearestCityGraphPoint = 20,
    FailedFindDespawnSpawner = 21,
    FailedFindLocatedSite = 22,
    FailedFindSubway = 23,
    FailedMoveOver = 24,
    SameSite = 25,
    NotEnoughCurrency = 26,
    OutOfMaxInteractionRange = 27,
    DifferentGameObjectState = 28,
    FailCheckInteractionConditions = 29,
    InvalidSpawner = 30,
    GrabBaby = 31,
    FailedPutDown = 32,
    FailedPutInSiteInventory = 33,
    HasWhitelistBuff = 34,
    User = 35,
    UserRequestMoveToSite = 36,
    UserRequestMoveToSiteUsingVehicle = 37,
    StopAutoDriving = 38,
    Coop = 39,
    Talk = 40,
    SubAction = 41,
    AddInteractionQueue_ClickInteractionBagCategory = 42,
    CoopCanceled = 43,
    TalkFinish = 44,
    TalkTimeout = 45,
    StartSleepwalking = 46,
    CancelInteractionScript = 47,
    DespawnRelationshipCrowd = 48,
    HitByVehicle = 49,
    AvoidVehicle = 50,
    FinishSchedule = 51,
    EndScheduleScript = 52,
    LateSchedule = 53,
    CancelSchedule = 54,
    SiteAction = 55,
    FamilyMoveToGoHome = 56,
    StartSiteEvent = 57,
    SocialEventAction = 58,
    Howling = 59,
    Cheat = 60,
    InvalidTargetEntity = 61,
    CancelTooExpensive = 62,
    InvalidSaleableObject = 63,
    ZoiSelectCanceled = 64,
    ForceStartCoop = 65,
    CharacterOverlap = 66,
    UnablePutdownObjectInVehicle = 67,
    InvalidVehicleExitLocation = 68,
    ChangePossess = 69,
    DriverRequest = 70,
    FailedMarriage = 71,
    EB1InteractionCancelReason_MAX = 72,
}

---@enum EB1InteractionCheckFailReason
local EB1InteractionCheckFailReason = {
    None = 0,
    InvalidInteractionBag = 1,
    InvalidRequestEntity = 2,
    InvalidPickedEntity = 3,
    GhostMismatch = 4,
    AgingCondition = 5,
    GhostNotAllowed = 6,
    InteractionConditionFailed = 7,
    FamilyRequiredForCurrency = 8,
    NotEnoughCurrency = 9,
    InvalidCity = 10,
    NotExistPathToSlot = 11,
    TargetSearchFailed = 12,
    MissingSlotComponent = 13,
    SiteManagerNotFound = 14,
    InvalidRequesterPathFinding = 15,
    InvalidData = 16,
    InvalidGrab = 17,
    GhostDenied = 18,
    NotFoundTarget = 19,
    CantOccupyInteractionSlot = 20,
    CantOccupyObjectSlotInvalidGrabObject = 21,
    CantOccupyObjectSlot = 22,
    FindTargetFailReason_Default = 23,
    EB1InteractionCheckFailReason_MAX = 24,
}

---@enum EB1InteractionFailReason
local EB1InteractionFailReason = {
    None = 0,
    InvalidSelectedSequence = 1,
    WalkToFail = 2,
    NotFoundSlot = 3,
    NotFoundTarget = 4,
    NotEnoughCurrency = 5,
    TryStartFail = 6,
    Finish = 7,
    CheckConditionFail = 8,
    CantOccupyObjectSlot = 9,
    CantOccupyInteractionSlot = 10,
    Canceled = 11,
    Rescue = 12,
    EB1InteractionFailReason_MAX = 13,
}

---@enum EB1InteractionPlayReason
local EB1InteractionPlayReason = {
    Invalid = 0,
    None = 1,
    NonCancelable = 2,
    User = 3,
    UserRequestMoveToSite = 4,
    UserRequestMoveToSiteUsingVehicle = 5,
    UserRequestMoveUsingPortal = 6,
    Autonomy = 7,
    StatNotEnough = 8,
    Schedule = 9,
    Coop = 10,
    Talk = 11,
    TalkFinish = 12,
    LifeTrigger = 13,
    Howling = 14,
    FailAction = 15,
    Reaction = 16,
    Story = 17,
    Dream = 18,
    SubAction = 19,
    MultiSequence = 20,
    Cheat = 21,
    Test = 22,
    Crowd = 23,
    PutDownInventory = 24,
    ActionCancel = 25,
    MoveOver = 26,
    Stuck = 27,
    SiteAction = 28,
    PlayNextInteraction = 29,
    FamilyMoveToGoHome = 30,
    SocialEventAction = 31,
    SocialEventTeleport = 32,
    CantAction = 33,
    CharacterOverlap = 34,
    TeleportToHomeNonCancelable = 35,
    DriverRequest = 36,
    EB1InteractionPlayReason_MAX = 37,
}

---@enum EB1InteractionTargetType
local EB1InteractionTargetType = {
    None = 0,
    Picked = 1,
    CarriableObject = 2,
    EB1InteractionTargetType_MAX = 3,
}

---@enum EB1InventoryId
local EB1InventoryId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1InventoryType
local EB1InventoryType = {
    Invalid = 0,
    Pocket = 1,
    Site = 2,
    Package = 3,
    EB1InventoryType_MAX = 4,
}

---@enum EB1InventoryUpdateReason
local EB1InventoryUpdateReason = {
    Invalid = 0,
    ChangePossess = 1,
    Update = 2,
    EB1InventoryUpdateReason_MAX = 3,
}

---@enum EB1JobType
local EB1JobType = {
    Invalid = 0,
    Normal = 1,
    Student = 2,
    Freelancer = 3,
    EB1JobType_MAX = 4,
}

---@enum EB1KarmaReportMenuType
local EB1KarmaReportMenuType = {
    Invalid = 0,
    KarmaDashboard = 1,
    ZoIList = 2,
    GhostList = 3,
    HermanNotice = 4,
    EB1KarmaReportMenuType_MAX = 5,
}

---@enum EB1KarmaStateType
local EB1KarmaStateType = {
    Danger = 0,
    Warning = 1,
    Normal = 2,
    Good = 3,
    EB1KarmaStateType_MAX = 4,
}

---@enum EB1LadderAnimPhase
local EB1LadderAnimPhase = {
    Ready = 0,
    SyncLocation = 1,
    PlayEnterLoopAnim = 2,
    PlayExitAnim = 3,
    EB1LadderAnimPhase_MAX = 4,
}

---@enum EB1LadderAttach
local EB1LadderAttach = {
    Default = 0,
    Ceiling = 1,
    Platform = 2,
    EB1LadderAttach_MAX = 3,
}

---@enum EB1LeaveCompanyReason
local EB1LeaveCompanyReason = {
    Invalid = 0,
    Normal = 1,
    Fire_Absence = 2,
    Fire_NewRecruits = 3,
    Fire_PromotionOfAnotherEmployee = 4,
    Error_AssignToNonExistentOrganization = 5,
    Transfer = 6,
    Death = 7,
    Marry = 8,
    Retire_Age = 9,
    Retire_Random = 10,
    Freeze = 11,
    GraduationSchool = 12,
    EntityDestroy = 13,
    EB1LeaveCompanyReason_MAX = 13,
}

---@enum EB1LifeTriggerStep
local EB1LifeTriggerStep = {
    Invalid = 0,
    Triggered = 1,
    AfterAlert = 2,
    EB1LifeTriggerStep_MAX = 3,
}

---@enum EB1LobbyIntroPlayType
local EB1LobbyIntroPlayType = {
    VideoPlayer = 0,
    LevelSequence = 1,
    EB1LobbyIntroPlayType_MAX = 2,
}

---@enum EB1LoopAnimSection
local EB1LoopAnimSection = {
    Default = 0,
    Loop = 1,
    End = 2,
    EB1LoopAnimSection_MAX = 3,
}

---@enum EB1LoopAnimType
local EB1LoopAnimType = {
    Start = 0,
    Loop = 1,
    End = 2,
    Invalid = 3,
    EB1LoopAnimType_MAX = 4,
}

---@enum EB1MakeRumorResult
local EB1MakeRumorResult = {
    Success = 0,
    SystemOff = 1,
    AlreadyDefined = 2,
    DataInvalid = 3,
    EB1MakeRumorResult_MAX = 4,
}

---@enum EB1MakeupChannel
local EB1MakeupChannel = {
    R = 0,
    G = 1,
    B = 2,
    A = 3,
    EB1MakeupChannel_MAX = 4,
}

---@enum EB1MapMode
local EB1MapMode = {
    Default = 0,
    SelectNewHouse = 1,
    SelectInitHouse = 2,
    SelectSubway = 3,
    SelectMoveHouse = 4,
    EB1MapMode_MAX = 5,
}

---@enum EB1MapNavigatorMenuType
local EB1MapNavigatorMenuType = {
    Invalid = 0,
    Family = 1,
    CityEnvironment = 2,
    Timeline = 3,
    CityTheme = 4,
    Weather = 5,
    SiteEdit = 6,
    CityBalance = 7,
    PhotoStudio = 8,
    CutsceneStudio = 9,
    DanceStudio = 10,
    KarmaReport = 11,
    Sign = 12,
    Tree = 13,
    Grass = 14,
    Decoration = 15,
    Animal = 16,
    SpecialEffect = 17,
    EB1MapNavigatorMenuType_MAX = 18,
}

---@enum EB1MaterialParamType
local EB1MaterialParamType = {
    Scalar = 0,
    Color = 1,
    Texture = 2,
    EB1MaterialParamType_MAX = 3,
}

---@enum EB1MeshSkinningTarget
local EB1MeshSkinningTarget = {
    Body = 0,
    Head = 1,
    MAX = 2,
}

---@enum EB1MetricType
local EB1MetricType = {
    Persistent = 0,
    Session = 1,
    Run = 2,
    Num = 128,
    ALL = 3,
    EB1MetricType_MAX = 129,
}

---@enum EB1MissionCondition
local EB1MissionCondition = {
    None = 0,
    GetCurrency = 1,
    HaveCurrency = 2,
    HaveCurrencyExactly = 3,
    HaveCurrencyUnder = 4,
    InteractionBagCount = 5,
    InteractionCount = 6,
    ActionTime = 7,
    SkillLevel = 8,
    HaveJob = 9,
    HaveJobRank = 10,
    RelationshipCount = 11,
    CompleteAmbitionMission = 12,
    BuyObject = 13,
    InteractionBagCountInSite = 14,
    InteractionBagTimeInSite = 15,
    EnterSiteCount = 16,
    InteractionBagTagCountInSiteTag = 17,
    InteractionBagTagTimeInSiteTag = 18,
    EnterSiteTagCount = 19,
    InteractionBagCountDuringEmotion = 20,
    InteractionCountDuringEmotion = 21,
    InteractionBagCountAtFamilyRelationshipType = 22,
    InteractionCountAtFamilyRelationshipType = 23,
    HaveFamilyCount = 24,
    HasChildMarried = 25,
    HaveEmploymentForm = 26,
    UpdateRankCount = 27,
    TakeASubway = 28,
    SkillsReachedLevel = 29,
    SitePrice = 30,
    SiteSize = 31,
    FamilyLoveDuringDay = 32,
    AddBuffCount = 33,
    AddEntityTagCount = 34,
    MissionClearCount = 35,
    GamePlayTime = 36,
    EB1MissionCondition_MAX = 37,
}

---@enum EB1MissionId
local EB1MissionId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1MissionType
local EB1MissionType = {
    None = 0,
    Hope = 1,
    Ambition = 2,
    Preference = 3,
    WorkMission = 4,
    WorldMission = 5,
    Quest = 6,
    EB1MissionType_MAX = 7,
}

---@enum EB1MobileMessageBaseObject
local EB1MobileMessageBaseObject = {
    Self = 0,
    Target = 1,
    Player = 2,
    System = 3,
    EB1MobileMessageBaseObject_MAX = 4,
}

---@enum EB1MobileMessageResponseType
local EB1MobileMessageResponseType = {
    Normal = 0,
    Positive = 1,
    Negative = 2,
    EB1MobileMessageResponseType_MAX = 3,
}

---@enum EB1ModifierOperationType
local EB1ModifierOperationType = {
    None = 0,
    Add = 1,
    Multiply = 2,
    SetMax = 3,
    PositiveAdd = 4,
    NegativeAdd = 5,
    PositiveMultiply = 6,
    NegativeMultiply = 7,
    EB1ModifierOperationType_MAX = 8,
}

---@enum EB1ModifierType
local EB1ModifierType = {
    Invalid = 0,
    None = 1,
    SkillExp = 2,
    Relationship = 3,
    BuffTime = 4,
    EmotionBuffTime = 5,
    Stat = 6,
    StatDecay = 7,
    AutonomyStat = 8,
    AutonomyInteraction = 9,
    InteractionResult = 10,
    InteractionBagResult = 11,
    InteractionSequenceProb = 12,
    Job = 13,
    Weathering = 14,
    GameConfig = 15,
    InteractionBagReward = 16,
    Howling = 17,
    Age = 18,
    DreamProbability = 19,
    DreamPoolWeight = 20,
    SubAction = 21,
    AutonomyStatHighPriority = 22,
    CraftingProgressTime = 23,
    EB1ModifierType_MAX = 24,
}

---@enum EB1MouseCursorType
local EB1MouseCursorType = {
    None = 0,
    BuildMode_Hammering = 1,
    BuildMode_BrushSingle = 2,
    BuildMode_BrushRoom = 3,
    BuildMode_BrushAdd = 4,
    BuildMode_BrushDel = 5,
    BuildMode_SelectRoom = 6,
    EB1MouseCursorType_MAX = 7,
}

---@enum EB1NameEnteredFailReason
local EB1NameEnteredFailReason = {
    Default = 0,
    EmptyName = 1,
    Punct = 2,
    Whitespace = 3,
    ExceedNumLimit = 4,
    NotValidCharacter = 5,
    EB1NameEnteredFailReason_MAX = 6,
}

---@enum EB1NavigationNodeType
local EB1NavigationNodeType = {
    Invalid = 0,
    None = 1,
    NavMesh = 2,
    CityGraph = 4,
    SiteArea = 8,
    Elevator = 16,
    TransportaionEnter = 32,
    TransportaionExit = 64,
    Door = 128,
    Stair = 256,
    Ladder = 512,
    Portal = 112,
    EB1NavigationNodeType_MAX = 513,
}

---@enum EB1NavigationPathCode
local EB1NavigationPathCode = {
    UNKNOWN = 0,
    SUCCESS = 1,
    ERROR_START_POSITION_NOT_PROVIDED = 2,
    ERROR_START_POSITION_NOT_FOUND = 3,
    ERROR_DESTINATION_NOT_PROVIDED = 4,
    ERROR_DESTINATION_NOT_FOUND = 5,
    ERROR_FAILED_SITE_AREA_PATH_FINDING = 6,
    ERROR_SITE_AREA_NOT_FOUND = 7,
    ERROR_SITE_AREA_ENTRANCE_NOT_FOUND = 8,
    ERROR_CITY_GRAPH_START_POINT_NOT_FOUND = 9,
    ERROR_CITY_GRAPH_END_POINT_NOT_FOUND = 10,
    ERROR_FAILED_NAVMESH_PATH_FINDING = 11,
    ERROR_UNREACHABLE = 12,
    ERROR_PORTAL_NOT_FOUND = 13,
    ERROR_PORTAL_SAME_LOCATION = 14,
    EB1NavigationPathCode_MAX = 15,
}

---@enum EB1NotyfyType
local EB1NotyfyType = {
    Invalid = 0,
    Notify = 1,
    NotifyState = 2,
    EB1NotyfyType_MAX = 3,
}

---@enum EB1ObjectBadgeIconType
local EB1ObjectBadgeIconType = {
    Psykhet = 0,
    StoryNpc = 1,
    Family = 2,
    Invalid = 255,
    EB1ObjectBadgeIconType_MAX = 256,
}

---@enum EB1ObjectCustomizeType
local EB1ObjectCustomizeType = {
    None = 0,
    MaterialOnly = 1,
    Assemble = 2,
    Floor = 3,
    Printed = 4,
    EB1ObjectCustomizeType_MAX = 5,
}

---@enum EB1OrderType
local EB1OrderType = {
    Invalid = 0,
    ONCE = 1,
    ESSENTIAL = 2,
    PERSISTENT = 3,
    RANDOMPERSISTENT = 4,
    ONCEDURING = 5,
    EB1OrderType_MAX = 6,
}

---@enum EB1OutfitCategory
local EB1OutfitCategory = {
    None = 0,
    Everyday = 1,
    Formal = 2,
    School = 3,
    Sleep = 4,
    Party = 5,
    Sports = 6,
    Swimwear = 7,
    Summer = 8,
    Winter = 9,
    MAX = 10,
}

---@enum EB1OverrideBaseObject
local EB1OverrideBaseObject = {
    Self = 0,
    Target = 1,
    Player = 2,
    EB1OverrideBaseObject_MAX = 3,
}

---@enum EB1PathFollowingPasue
local EB1PathFollowingPasue = {
    Portal = 0,
    SubAction = 1,
    EB1PathFollowingPasue_MAX = 2,
}

---@enum EB1PauseReason
local EB1PauseReason = {
    Invalid = 0,
    BuildMode = 1,
    FamilyMove = 2,
    CommonPopup = 3,
    CommonBuyPopup = 4,
    DramaPopup = 5,
    SaveLoadPopup = 6,
    GameMenu = 7,
    SceneSetting = 8,
    PlayerInput = 9,
    PlayerFamilyDeath = 10,
    PostPlayerFamilyDeath = 11,
    Loading = 12,
    Initialize = 13,
    SaveSitePathFindingData = 14,
    CharacterCustomization = 15,
    GameOption = 16,
    FirstPossessKeyGuide = 17,
    FamilyEdit = 18,
    SelectSubway = 19,
    Rescue = 20,
    PhotoMode = 21,
    VehiclePurchase = 22,
    KarmaAction = 23,
    CatTalk = 24,
    GalleryBrowser = 25,
    MapUI = 26,
    VideoPlay = 27,
    Crafting = 28,
    RelationshipProfile = 29,
    NumericPopup = 30,
    ChoiceCardPopup = 31,
    HopeLife = 32,
    GenerateMotion = 33,
    CoopSelect = 34,
    SocialEventPopup = 35,
    ReportIssue = 36,
    SelectSlotOwnership = 37,
    MoveTogether = 38,
    EB1PauseReason_MAX = 39,
}

---@enum EB1PhotoModeCameraCropOption
local EB1PhotoModeCameraCropOption = {
    AspectRatio_4_3 = 0,
    AspectRatio_3_4 = 1,
    AspectRatio_1_1 = 2,
    AspectRatio_16_9 = 3,
    AspectRatio_9_16 = 4,
    AspectRatio_10_6 = 5,
    AspectRatio_6_10 = 6,
    AspectRatio_MAX = 7,
}

---@enum EB1PhotoModeCameraOptionSettingType
local EB1PhotoModeCameraOptionSettingType = {
    FOV = 0,
    DOF = 1,
    CustomDepthMask = 2,
    EB1PhotoModeCameraOptionSettingType_MAX = 3,
}

---@enum EB1PlacementFlag
local EB1PlacementFlag = {
    None = 0,
    Floor = 1,
    Slot = 2,
    Wall = 4,
    NoCollision = 8,
    Ceil = 16,
    Blueprint = 32,
    Fence = 64,
    Airborne = 128,
    Soot = 256,
    EB1PlacementFlag_MAX = 257,
}

---@enum EB1PlayAnimConditionType
local EB1PlayAnimConditionType = {
    None = 0,
    Fat = 1,
    Garment = 2,
    EB1PlayAnimConditionType_MAX = 3,
}

---@enum EB1PlayerSpawnCompletedContent
local EB1PlayerSpawnCompletedContent = {
    BaseSetting = 0,
    Appearance = 1,
    Max = 2,
}

---@enum EB1PlayerSpawnId
local EB1PlayerSpawnId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1PlayerTag
local EB1PlayerTag = {
    Player = 0,
    Npc = 1,
    RelationshipCrowd = 2,
    EB1PlayerTag_MAX = 3,
}

---@enum EB1PocketMarketGrade
local EB1PocketMarketGrade = {
    None = 0,
    Bronze = 1,
    Silver = 2,
    Gold = 3,
    EB1PocketMarketGrade_MAX = 4,
}

---@enum EB1PocketMarketShoppingItemSaleState
local EB1PocketMarketShoppingItemSaleState = {
    None = 0,
    ForSale = 1,
    OnSale = 2,
    EB1PocketMarketShoppingItemSaleState_MAX = 3,
}

---@enum EB1PocketMarketTabType
local EB1PocketMarketTabType = {
    Shopping = 0,
    HomeService = 1,
    Sell = 2,
    Orders = 3,
    EB1PocketMarketTabType_MAX = 4,
}

---@enum EB1PopupType
local EB1PopupType = {
    Common = 0,
    CommonBuy = 1,
    Drama = 2,
    Cat = 3,
    ChoiceCard = 4,
    SocialEvent = 5,
    None = 255,
    EB1PopupType_MAX = 256,
}

---@enum EB1PortraitFocusState
local EB1PortraitFocusState = {
    Focus = 0,
    ClickToFocus = 1,
    TabToFocus = 2,
    EB1PortraitFocusState_MAX = 3,
}

---@enum EB1PoseType
local EB1PoseType = {
    Invalid = 0,
    StudioPose = 1,
    MyMotion = 2,
    EB1PoseType_MAX = 3,
}

---@enum EB1PostPlayerSpawn
local EB1PostPlayerSpawn = {
    None = 0,
    Baby = 1,
    Family = 2,
    Schedule = 3,
    CompanyRoleNpc = 4,
    AddFamilyByCheat = 5,
    RelationshipCrowd = 6,
    EB1PostPlayerSpawn_MAX = 7,
}

---@enum EB1PostureType
local EB1PostureType = {
    Stand = 0,
    Sit = 1,
    Sleep = 2,
    Vehicle = 3,
    Lay = 4,
    Carried = 5,
    EB1PostureType_MAX = 6,
}

---@enum EB1PreferencePanelType
local EB1PreferencePanelType = {
    Normal = 0,
    Like = 1,
    Dislike = 2,
    EB1PreferencePanelType_MAX = 3,
}

---@enum EB1PreferenceState
local EB1PreferenceState = {
    Common = 0,
    Like = 1,
    Dislike = 2,
    EB1PreferenceState_MAX = 3,
}

---@enum EB1PregnancyState
local EB1PregnancyState = {
    None = 0,
    Pregnancy = 1,
    EB1PregnancyState_MAX = 2,
}

---@enum EB1Quality
local EB1Quality = {
    None = 0,
    Bad = 1,
    Fair = 2,
    Good = 3,
    High = 4,
    Superb = 5,
    EB1Quality_MAX = 6,
}

---@enum EB1ReactionAnimType
local EB1ReactionAnimType = {
    Invalid = 0,
    FullBody = 1,
    UpperBody = 2,
    EB1ReactionAnimType_MAX = 3,
}

---@enum EB1ReactionResult
local EB1ReactionResult = {
    None = 0,
    Probability = 1,
    UnsatisfiedRelationship = 2,
    UnavailableAnim = 3,
    InvalidReactionType = 4,
    Success = 5,
    EB1ReactionResult_MAX = 6,
}

---@enum EB1RelationShipZoiSelectModeType
local EB1RelationShipZoiSelectModeType = {
    None = 0,
    Coop = 1,
    Ownership = 2,
    MoveTogether = 3,
    EB1RelationShipZoiSelectModeType_MAX = 4,
}

---@enum EB1RelationshipChemistry
local EB1RelationshipChemistry = {
    Invalid = 0,
    VeryGood = 1,
    Good = 2,
    Normal = 3,
    Bad = 4,
    VeryBad = 5,
    EB1RelationshipChemistry_MAX = 6,
}

---@enum EB1RelationshipFamilyLoveType
local EB1RelationshipFamilyLoveType = {
    Invalid = 0,
    Worst = 1,
    Bad = 2,
    Good = 3,
    Best = 4,
    EB1RelationshipFamilyLoveType_MAX = 5,
}

---@enum EB1RelationshipFxType
local EB1RelationshipFxType = {
    None = 0,
    Romance = 1,
    Business = 2,
    Friendship = 3,
    Family = 4,
    FocusSelection = 5,
    Max = 6,
}

---@enum EB1RelationshipId
local EB1RelationshipId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1RelationshipListFilterType
local EB1RelationshipListFilterType = {
    None = 0,
    All = 1,
    Home = 2,
    Love = 3,
    Family = 4,
    Business = 5,
    Friendship = 6,
    EB1RelationshipListFilterType_MAX = 7,
}

---@enum EB1RelationshipProfileType
local EB1RelationshipProfileType = {
    None = 0,
    Gender = 1,
    Aging = 2,
    Marriage = 3,
    Trait = 4,
    Job = 5,
    TraitValue = 6,
    Preference = 7,
    RomanticOrientation = 8,
    RomanceTarget = 9,
    Max = 10,
}

---@enum EB1RelationshipStatPriorityType
local EB1RelationshipStatPriorityType = {
    None = 0,
    Family = 1,
    Romance = 2,
    Business = 3,
    Friendship = 4,
    Max = 5,
}

---@enum EB1RoundType
local EB1RoundType = {
    None = 0,
    Round = 1,
    RoundUp = 2,
    RoundDown = 3,
    EB1RoundType_MAX = 4,
}

---@enum EB1RumorEventPlayResult
local EB1RumorEventPlayResult = {
    Success = 0,
    SystemOff = 1,
    Failed = 2,
    InvalidData = 3,
    InvalidMessageId = 4,
    SenderNotFound = 5,
    EB1RumorEventPlayResult_MAX = 6,
}

---@enum EB1RumorEventType
local EB1RumorEventType = {
    Invalid = 0,
    Positive = 1,
    Negative = 2,
    Expire = 3,
    Custom = 4,
    EB1RumorEventType_MAX = 5,
}

---@enum EB1RumorTransferResult
local EB1RumorTransferResult = {
    Success = 0,
    SystemOff = 1,
    TargetIsMonger = 2,
    AlreadyHasRumor = 3,
    NotValidRumor = 4,
    EB1RumorTransferResult_MAX = 5,
}

---@enum EB1ScheduleControlState
local EB1ScheduleControlState = {
    Invalid = 0,
    None = 1,
    Accept = 2,
    Hold = 3,
    Cancel = 4,
    EB1ScheduleControlState_MAX = 5,
}

---@enum EB1ScheduleControlStateChangeReason
local EB1ScheduleControlStateChangeReason = {
    Invalid = 0,
    User = 1,
    CompanyRoleNpcCancelCauseNotWorkingSchedule = 2,
    InvalidSite = 3,
    ApplyOverideTimeline = 4,
    DeleteOverideTimeline = 5,
    EditSchedule = 6,
    EB1ScheduleControlStateChangeReason_MAX = 7,
}

---@enum EB1ScheduleDestType
local EB1ScheduleDestType = {
    Invalid = 0,
    Site = 1,
    Spawner = 2,
    RabbitHole = 3,
    Tag = 4,
    EB1ScheduleDestType_MAX = 5,
}

---@enum EB1ScheduleMoveType
local EB1ScheduleMoveType = {
    Invalid = 0,
    MoveNormal = 1,
    MoveVehicle = 2,
    EB1ScheduleMoveType_MAX = 3,
}

---@enum EB1ScheduleType
local EB1ScheduleType = {
    Invalid = 0,
    Normal = 1,
    Custom = 2,
    Override = 3,
    AICreated = 4,
    EB1ScheduleType_MAX = 5,
}

---@enum EB1SchedulerId
local EB1SchedulerId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1ScriptReason
local EB1ScriptReason = {
    Invalid = 0,
    None = 1,
    Action = 2,
    Ambition = 3,
    Bio = 4,
    Buff = 5,
    Build = 6,
    CarriableObject = 7,
    CatShop = 8,
    Cheat = 9,
    Company = 10,
    Coop = 11,
    Crafting = 12,
    Decay = 13,
    Door = 14,
    Dream = 15,
    Emotion = 16,
    Ghost = 17,
    GrowthChanged = 18,
    Hope = 19,
    Howling = 20,
    Instinct = 21,
    Interaction = 22,
    InteractionUIVisible = 23,
    Inventory = 24,
    Job = 25,
    Life = 26,
    MobileMessage = 27,
    Npc = 28,
    PopulationSystem = 29,
    Posture = 30,
    Quest = 31,
    RabbitHole = 32,
    Relationship = 33,
    Rumor = 34,
    Service = 35,
    SiteAction = 36,
    SiteTimeline = 37,
    Slot = 38,
    Skill = 39,
    Stat = 40,
    State = 41,
    SubAction = 42,
    Talk = 43,
    Timeline = 44,
    Trait = 45,
    UI = 46,
    Vehicle = 47,
    WeatherChanged = 48,
    WorldEvent = 49,
    WorldMission = 50,
    ChoiceCard = 51,
    SocialEvent = 52,
    SiteEvent = 53,
    RevertTemporaryAppearance = 54,
    SiteActionTrigger = 55,
    PocketMarket = 56,
    SpawnCrowd = 57,
    Meeting = 58,
    Death = 59,
    EB1ScriptReason_MAX = 60,
}

---@enum EB1SeasonType
local EB1SeasonType = {
    None = 0,
    Spring = 1,
    Summer = 2,
    Fall = 3,
    Winter = 4,
    EB1SeasonType_MAX = 5,
}

---@enum EB1SelectionType
local EB1SelectionType = {
    Normal = 0,
    Remote = 1,
    Door = 2,
    EB1SelectionType_MAX = 3,
}

---@enum EB1ServiceType
local EB1ServiceType = {
    Invalid = 0,
    Electricity = 1,
    Water = 2,
    Max = 3,
}

---@enum EB1ServiceVisitType
local EB1ServiceVisitType = {
    None = 0,
    Personal = 1,
    Site = 2,
    SiteEvent = 3,
    EB1ServiceVisitType_MAX = 4,
}

---@enum EB1ShoesType
local EB1ShoesType = {
    None = 0,
    Slippers = 1,
    Sneakers = 2,
    DressShoes = 3,
    Boots = 4,
    Max = 255,
}

---@enum EB1ShowRecruitInfoState
local EB1ShowRecruitInfoState = {
    Invalid = 0,
    CanJoin = 1,
    CanJoinButEmptyHeadcount = 2,
    NotMeetCondition = 3,
    AlreadyJoined = 4,
    Unrecruitable = 5,
    EB1ShowRecruitInfoState_MAX = 6,
}

---@enum EB1ShowRequireSpaceType
local EB1ShowRequireSpaceType = {
    Default = 0,
    Expand = 1,
    EB1ShowRequireSpaceType_MAX = 2,
}

---@enum EB1SimulationLODBase
local EB1SimulationLODBase = {
    Camera = 0,
    ControlledPlayer = 1,
    EB1SimulationLODBase_MAX = 2,
}

---@enum EB1SimulationLevel
local EB1SimulationLevel = {
    Invalid = 0,
    SLOD0 = 1,
    SLOD1 = 2,
    EB1SimulationLevel_MAX = 3,
}

---@enum EB1SimulationSelect
local EB1SimulationSelect = {
    B1 = 0,
    B2 = 1,
    EB1SimulationSelect_MAX = 2,
}

---@enum EB1SiteActionReason
local EB1SiteActionReason = {
    Invalid = 0,
    Tax = 1,
    Fire = 2,
    Repair = 3,
    SiteActionTrigger = 4,
    Death = 5,
    EB1SiteActionReason_MAX = 6,
}

---@enum EB1SiteActionTarget
local EB1SiteActionTarget = {
    Invalid = 0,
    Objects = 1,
    Inventory = 2,
    Visitors = 3,
    ResidanceFamilyMembers = 4,
    EB1SiteActionTarget_MAX = 5,
}

---@enum EB1SiteActionType
local EB1SiteActionType = {
    Invalid = 0,
    RunScriptId = 1,
    AddInteractionBag = 2,
    RunScriptToTarget = 3,
    EB1SiteActionType_MAX = 4,
}

---@enum EB1SiteAreaType
local EB1SiteAreaType = {
    None = 0,
    Company = 1,
    Home = 2,
    EB1SiteAreaType_MAX = 3,
}

---@enum EB1SiteAreaUnit
local EB1SiteAreaUnit = {
    Object = 0,
    Grid = 1,
    EB1SiteAreaUnit_MAX = 2,
}

---@enum EB1SiteEventCancelReason
local EB1SiteEventCancelReason = {
    None = 0,
    HostCancel = 1,
    Attendance = 2,
    EB1SiteEventCancelReason_MAX = 3,
}

---@enum EB1SiteEventResult
local EB1SiteEventResult = {
    None = 0,
    Cancel = 1,
    Success = 2,
    EB1SiteEventResult_MAX = 3,
}

---@enum EB1SiteEventRoleScriptType
local EB1SiteEventRoleScriptType = {
    None = 0,
    Create = 1,
    Start = 2,
    Cancel = 3,
    Finish = 4,
    EB1SiteEventRoleScriptType_MAX = 5,
}

---@enum EB1SiteEventState
local EB1SiteEventState = {
    None = 0,
    Waiting = 1,
    Playing = 2,
    Ended = 3,
    EB1SiteEventState_MAX = 4,
}

---@enum EB1SiteEventTargetRoleOption
local EB1SiteEventTargetRoleOption = {
    None = 0,
    Any = 1,
    PreferMale = 2,
    PreferFemale = 3,
    EB1SiteEventTargetRoleOption_MAX = 4,
}

---@enum EB1SiteEventTargetType
local EB1SiteEventTargetType = {
    None = 0,
    Any = 1,
    Role = 2,
    EB1SiteEventTargetType_MAX = 3,
}

---@enum EB1SiteEventTimeSettingType
local EB1SiteEventTimeSettingType = {
    None = 0,
    FastHour = 1,
    FastNoon = 2,
    EB1SiteEventTimeSettingType_MAX = 3,
}

---@enum EB1SiteEventType
local EB1SiteEventType = {
    None = 0,
    SocialEvent = 1,
    FireEvent = 2,
    EB1SiteEventType_MAX = 3,
}

---@enum EB1SitePriceFlags
local EB1SitePriceFlags = {
    None = 0,
    Default = 1,
    Rooms = 2,
    Objects = 4,
    All = 7,
    EB1SitePriceFlags_MAX = 8,
}

---@enum EB1SiteState
local EB1SiteState = {
    Normal = 0,
    UnOccupied = 1,
    Occupied = 2,
    UnOccupiedEmptyLand = 3,
    EB1SiteState_MAX = 4,
}

---@enum EB1SiteSubType
local EB1SiteSubType = {
    Default = 0,
    Studio = 1,
    EB1SiteSubType_MAX = 2,
}

---@enum EB1SiteType
local EB1SiteType = {
    Invalid = 0,
    Residence = 1,
    Public = 2,
    Business = 3,
    Subway = 4,
    OutsideResidence = 5,
    Override = 6,
    Street = 7,
    Bus = 8,
    MyVehicle = 9,
    EB1SiteType_MAX = 10,
}

---@enum EB1SkinColorApplyMode
local EB1SkinColorApplyMode = {
    UsingColorId = 0,
    UsingSkinTone = 1,
    UsingDefaultMaterial = 2,
    EB1SkinColorApplyMode_MAX = 3,
}

---@enum EB1SloFXEffectType
local EB1SloFXEffectType = {
    Niagara = 0,
    Particle = 1,
    EB1SloFXEffectType_MAX = 2,
}

---@enum EB1SlotDirection
local EB1SlotDirection = {
    None = 0,
    Left = 1,
    Right = 2,
    EB1SlotDirection_MAX = 3,
}

---@enum EB1SlotOccupyingReason
local EB1SlotOccupyingReason = {
    None = 0,
    Interaction = 1,
    Posture = 2,
    Object = 3,
    Coop = 4,
    VehicleSeat = 5,
    UnusableLocation = 6,
    EB1SlotOccupyingReason_MAX = 7,
}

---@enum EB1SlotPreviewType
local EB1SlotPreviewType = {
    None = 0,
    StaticMesh = 1,
    SkeletalMesh = 2,
    Fx = 3,
    EB1SlotPreviewType_MAX = 4,
}

---@enum EB1SlotState
local EB1SlotState = {
    None = 0,
    Occupying = 1,
    Unusable = 2,
    EB1SlotState_MAX = 3,
}

---@enum EB1SlotType
local EB1SlotType = {
    None = 0,
    Interaction = 1,
    Object = 2,
    Fx = 3,
    ExtraRequireSpace = 4,
    Audio = 5,
    EB1SlotType_MAX = 6,
}

---@enum EB1SlotUsageType
local EB1SlotUsageType = {
    Invalid = 0,
    None = 1,
    Single = 2,
    Double = 3,
    EB1SlotUsageType_MAX = 4,
}

---@enum EB1SmartZoiAppliedArea
local EB1SmartZoiAppliedArea = {
    Invalid = 0,
    ControlledZoi = 1,
    ControlledFamilyZoi = 2,
    AllOfZoiInCity = 3,
    EB1SmartZoiAppliedArea_MAX = 4,
}

---@enum EB1SocialEventActionFinishOption
local EB1SocialEventActionFinishOption = {
    None = 0,
    OneFinish = 1,
    HalfFinish = 2,
    AllFinish = 3,
    EB1SocialEventActionFinishOption_MAX = 4,
}

---@enum EB1SocialEventActionPlayReason
local EB1SocialEventActionPlayReason = {
    None = 0,
    PlayButton = 1,
    AutoScenario = 2,
    EB1SocialEventActionPlayReason_MAX = 3,
}

---@enum EB1SocialEventActionState
local EB1SocialEventActionState = {
    None = 0,
    Waiting = 1,
    Playing = 2,
    ScenarioBlocked = 3,
    ConditionBlocked = 4,
    Complete = 5,
    EB1SocialEventActionState_MAX = 6,
}

---@enum EB1SocialEventActionTargetType
local EB1SocialEventActionTargetType = {
    None = 0,
    Role = 1,
    Object = 2,
    EB1SocialEventActionTargetType_MAX = 3,
}

---@enum EB1SocialEventMainPopupStep
local EB1SocialEventMainPopupStep = {
    PresetPage = 0,
    RolePage = 1,
    ReadyPage = 2,
    Finish = 3,
    EB1SocialEventMainPopupStep_MAX = 4,
}

---@enum EB1SpawnerType
local EB1SpawnerType = {
    Invalid = 0,
    Character = 1,
    Service = 2,
    Mesh = 3,
    EB1SpawnerType_MAX = 4,
}

---@enum EB1SpeechBubbleOption
local EB1SpeechBubbleOption = {
    Basic = 0,
    Icon = 1,
    Talking = 2,
    EB1SpeechBubbleOption_MAX = 3,
}

---@enum EB1SprintReason
local EB1SprintReason = {
    Invalid = 0,
    Shift = 1,
    WalkToZoneGraph = 2,
    ScheduleExceedTime = 3,
    WalkToActionUseSprint = 4,
    Script = 5,
    Service = 6,
    EB1SprintReason_MAX = 7,
}

---@enum EB1StairsAttach
local EB1StairsAttach = {
    Default = 0,
    Ceiling = 1,
    Platform = 2,
    Floor = 3,
    EB1StairsAttach_MAX = 4,
}

---@enum EB1StairsAttachDirection
local EB1StairsAttachDirection = {
    Forward = 0,
    Left = 1,
    Right = 2,
    EB1StairsAttachDirection_MAX = 3,
}

---@enum EB1StairsLanding
local EB1StairsLanding = {
    Default = 0,
    Landing_90_180 = 1,
    Landing_90 = 2,
    Landing_0 = 3,
    Landing_270 = 4,
    Landing_270_180 = 5,
    EB1StairsLanding_MAX = 6,
}

---@enum EB1StatServiceTier
local EB1StatServiceTier = {
    Invalid = 0,
    Full = 1,
    Limited = 2,
    EB1StatServiceTier_MAX = 3,
}

---@enum EB1StatType
local EB1StatType = {
    Invalid = 0,
    Motive = 1,
    Hobby = 2,
    Work = 3,
    Visitor = 4,
    Weathering = 5,
    Object = 6,
    EB1StatType_MAX = 7,
}

---@enum EB1StateType
local EB1StateType = {
    Invalid = 0,
    Alive = 1,
    Ghost = 2,
    Both = 3,
    EB1StateType_MAX = 4,
}

---@enum EB1StateUIType
local EB1StateUIType = {
    Stat = 0,
    Relationship = 1,
    EB1StateUIType_MAX = 2,
}

---@enum EB1StateVariationType
local EB1StateVariationType = {
    None = 0,
    ChangeStaticMesh = 1,
    AttachStaticMesh = 2,
    NotSetStaticMesh = 3,
    PlayFX = 4,
    PlayAnimation = 5,
    ChangeMaterialLayerParam = 6,
    ComponentVisibility = 7,
    PlaySound = 8,
    StopSound = 9,
    SpawnFire = 10,
    UnableBuildMode = 11,
    EB1StateVariationType_MAX = 12,
}

---@enum EB1Stencil
local EB1Stencil = {
    NONE = 0,
    EMPHASIZE_STENCIL = 1,
    INTERACTEE_STENCIL = 2,
    INTERACTEE_PARENT_STENCIL = 4,
    INTERACTEE_SIBLING_STENCIL = 8,
    GHOST_STENCIL = 16,
    EB1Stencil_MAX = 17,
}

---@enum EB1StreamingSourceHandleMethod
local EB1StreamingSourceHandleMethod = {
    Invalid = 0,
    KeepCurrentActorLocation = 1,
    KeepCurrentType = 2,
    EB1StreamingSourceHandleMethod_MAX = 3,
}

---@enum EB1StringTableType
local EB1StringTableType = {
    None = 0,
    Action = 1,
    Aging = 2,
    AlertMessage = 3,
    Ambition = 4,
    AmbitionItem = 5,
    AppearanceParts = 6,
    AppearanceMakeup = 7,
    AppearanceMakeupParts = 8,
    AttachedAccessory = 9,
    Buff = 10,
    BuildPreset = 11,
    CatTalkMenuUI = 12,
    CatTalkTutorial = 13,
    CatOperatorMessage = 14,
    CatShop = 15,
    CityEdit = 16,
    CityEditMenu = 17,
    CityEditReport = 18,
    CityEditStability = 19,
    Company = 20,
    CompanyCondition = 21,
    CostumeEditParts = 22,
    Crafting = 23,
    Currency = 24,
    CustomMobileMessage = 25,
    DataFilter = 26,
    DataSort = 27,
    Death = 28,
    Dev = 29,
    DoorMessage = 30,
    Emotion = 31,
    Family = 32,
    FamilyNamePool = 33,
    FamilyRelationshipName = 34,
    FamilyMonitoringNotification = 35,
    FirstNamePool = 36,
    FreeChatbot = 37,
    GameOption = 38,
    GameOptionCategory = 39,
    Garment = 40,
    GarmentSubCategory = 41,
    GroupedObject = 42,
    Hope = 43,
    HopeLife = 44,
    InteractionBag = 45,
    InteractionBagGroup = 46,
    Inventory = 47,
    Job = 48,
    KarmaReportMenu = 49,
    LifeTrigger = 50,
    Map = 51,
    MapNavigatorMainMenu = 52,
    Message = 53,
    Mission = 54,
    MobileMessage = 55,
    MobileMessageSystem = 56,
    Object = 57,
    ObjectCategory = 58,
    ObjectChangeMaterialGroup = 59,
    ObjectChangeMeshGroup = 60,
    ObjectCustomizeMaterialGroup = 61,
    ObjectCustomizeMaterialParts = 62,
    ObjectCustomizeShapeTemplates = 63,
    PerspectiveDisplayInfoGroup = 64,
    Popup = 65,
    Preference = 66,
    RabbitHole = 67,
    RandomResult = 68,
    RandomTalkEmoticon = 69,
    Relationship = 70,
    RelationshipCategory = 71,
    RelationshipStat = 72,
    RelationshipRecord = 73,
    SavePresetRoomType = 74,
    ScheduleInfo = 75,
    Season = 76,
    Site = 77,
    SiteTypeUIInfo = 78,
    Skill = 79,
    SpeechBubble = 80,
    Stat = 81,
    TalkSelection = 82,
    Trait = 83,
    TraitSelect = 84,
    TraitSelect3 = 85,
    TraitChemistryReward = 86,
    TraitValue = 87,
    UI = 88,
    Vehicle = 89,
    VideoChatbot = 90,
    Weathering = 91,
    Widget = 92,
    WidgetMarker = 93,
    Rumor = 94,
    ChoiceCard = 95,
    RecipeGroup = 96,
    RecipeNamingPool = 97,
    SiteEvent = 98,
    SocialEventTemplate = 99,
    InteractionCategory = 100,
    QuestCategory = 101,
    PocketMarketShoppingCategory = 102,
    Sku = 103,
    End = 104,
    EB1StringTableType_MAX = 105,
}

---@enum EB1StuckReason
local EB1StuckReason = {
    None = 0,
    HomeDusty = 1,
    HomeFire = 2,
    FamilyRelationship = 3,
    CurrencySalvation = 4,
    NotEnoughBed = 5,
    AutonomyTime = 6,
    NotEnoughStat = 7,
    EB1StuckReason_MAX = 8,
}

---@enum EB1StudioCardType
local EB1StudioCardType = {
    Invalid = 0,
    Marriage = 1,
    Propose = 2,
    PhotoGuide = 3,
    EB1StudioCardType_MAX = 4,
}

---@enum EB1SubActionType
local EB1SubActionType = {
    Reaction = 0,
    PlayAnim = 1,
    Avoidance = 2,
    AvoidanceVehicle = 3,
    Greeting = 4,
    Talk = 5,
    End = 6,
    Invalid = 7,
    EB1SubActionType_MAX = 8,
}

---@enum EB1TalkNature
local EB1TalkNature = {
    Normal = 0,
    Positive = 1,
    Negative = 2,
    Emotion = 3,
    Trait = 4,
    RelationshipFocus = 5,
    Special = 6,
    Essential = 7,
    EB1TalkNature_MAX = 8,
}

---@enum EB1TalkSoundType
local EB1TalkSoundType = {
    None = 0,
    Friendship = 1,
    Romance = 2,
    Business = 3,
    EB1TalkSoundType_MAX = 4,
}

---@enum EB1TalkVoiceSourceType
local EB1TalkVoiceSourceType = {
    Host = 0,
    Target = 1,
    Max = 2,
}

---@enum EB1TargetFilterType
local EB1TargetFilterType = {
    Invalid = 0,
    InteractionBagId = 1,
    InteractionBagCategory = 2,
    Posture = 3,
    ObjectId = 4,
    Character = 5,
    GrabObject = 6,
    CarriedObject = 7,
    Vehicle = 8,
    OwnedVehicle = 9,
    VehiclePassenger = 10,
    ConnectedChairObject = 11,
    RelationshipStat = 12,
    Stat = 13,
    Site = 14,
    CharacterDiningSlot = 15,
    PutDownDiningSlot = 16,
    PickedObjectSlot = 17,
    ChairObject = 18,
    CoopRole = 19,
    Tag = 20,
    EntityTag = 21,
    PickedObjectOccupiedSlot = 22,
    SiteEventRole = 23,
    Engagement = 24,
    Spouse = 25,
    TalkLocation = 26,
    ServiceTrigger = 27,
    ServiceExecutioner = 28,
    ObjectTag = 29,
    InteractionBagIdDoNotCheckOccupyEntityId = 30,
    EB1TargetFilterType_MAX = 31,
}

---@enum EB1TargetObjectType
local EB1TargetObjectType = {
    InteractionTargetObject = 0,
    PostureTargetObject = 1,
    EB1TargetObjectType_MAX = 2,
}

---@enum EB1TaxChargeState
local EB1TaxChargeState = {
    Invalid = 0,
    BeforeCharge = 1,
    Charged = 2,
    CancelCharged = 3,
    Delinquency = 4,
    Seizure = 5,
    SeizureFailed = 6,
    Liquidation = 7,
    LiquidationFailed = 8,
    Max = 9,
}

---@enum EB1Temperature
local EB1Temperature = {
    None = 0,
    Celsius = 1,
    Fahrenheit = 2,
    EB1Temperature_MAX = 3,
}

---@enum EB1TemperatureRange
local EB1TemperatureRange = {
    None = 0,
    Freezing = 1,
    Cold = 2,
    Cool = 3,
    Mild = 4,
    Warm = 5,
    Burning = 6,
    Heatwave = 7,
    EB1TemperatureRange_MAX = 8,
}

---@enum EB1TemporaryChangeAppearanceType
local EB1TemporaryChangeAppearanceType = {
    None = 0,
    HairColor = 1,
    MuscleMass = 2,
    BodyMassRatio = 3,
    SkinTone = 4,
    MAX = 5,
}

---@enum EB1TestScenarioResult
local EB1TestScenarioResult = {
    Invalid = 0,
    Success = 1,
    Fail = 2,
    TimeOut = 3,
    Abort = 4,
    EB1TestScenarioResult_MAX = 5,
}

---@enum EB1TimeControlState
local EB1TimeControlState = {
    Invalid = 0,
    Paused = 1,
    Normal = 2,
    Fast = 3,
    VeryFast = 4,
    EB1TimeControlState_MAX = 5,
}

---@enum EB1TooltipWidgetType
local EB1TooltipWidgetType = {
    Default = 0,
    Skill = 1,
    Hope = 2,
    HousingObject = 3,
    EmotionGauge = 4,
    Schedule = 5,
    SitePreset = 6,
    HousingObjectCategory = 7,
    Relationship = 8,
    Material = 9,
    CanvasAppearance = 10,
    PlayerChangePortrait = 11,
    RelationshipProfile = 12,
    SocialEventAction = 13,
    PrintedAccessoryObjectTooltip = 14,
    EB1TooltipWidgetType_MAX = 15,
}

---@enum EB1TraitCategoryType
local EB1TraitCategoryType = {
    None = 0,
    Nature = 1,
    Perspective = 2,
    Ambition = 3,
    HopeLife = 4,
    EB1TraitCategoryType_MAX = 5,
}

---@enum EB1TraitEntryType
local EB1TraitEntryType = {
    Invalid = 0,
    OccasionalBuff = 1,
    ProximityBuff = 2,
    Broadcaster = 3,
    FailureBuff = 4,
    TriggeredBuff = 5,
    TriggeredEvent = 6,
    EB1TraitEntryType_MAX = 7,
}

---@enum EB1TraitEventTriggerType
local EB1TraitEventTriggerType = {
    None = 0,
    InteractionRepeat = 1,
    TrafficAccident = 2,
    ChangeCurrency = 3,
    CanelSchedule = 4,
    LeaveWorkOrSchoolSchedule = 5,
    BuyNewFurniture = 6,
    TakeASubway = 7,
    NotArrivedSchedule = 8,
    EnterNewSite = 9,
    EnteredSite = 10,
    EB1TraitEventTriggerType_MAX = 11,
}

---@enum EB1TransportAudioResourceType
local EB1TransportAudioResourceType = {
    None = 0,
    EnterSubway = 1,
    ExitSubway = 2,
    EnterBus = 3,
    ExitBus = 4,
    EnterElevator = 5,
    ExitElevator = 6,
    EB1TransportAudioResourceType_MAX = 7,
}

---@enum EB1UIType
local EB1UIType = {
    None = 0,
    Hud = 1,
    HudHope = 2,
    Inventory = 3,
    MsgBox = 4,
    Relationship = 5,
    ObjectInteraction = 6,
    CharacterMenu = 7,
    Tooltip = 8,
    DebugMessage = 9,
    Cheat = 10,
    MainMenu = 11,
    PreferenceSelect = 12,
    PerspectiveSelect = 13,
    CitySelect = 14,
    TalkInteraction = 15,
    BuildProgression = 16,
    GameMenu = 17,
    BuildKeyGuide = 18,
    MapNavigator = 19,
    Map = 20,
    SiteInfoButton = 21,
    MapFamilySelect = 22,
    MapFamilyListPopup = 23,
    MapFamilyMoveOptionPopup = 24,
    MapPlayerPortrait = 25,
    MapContextMenu = 26,
    SpeechBubble = 27,
    ChangeAmbition = 28,
    AlertMessage = 29,
    BuildMode = 30,
    BuildModeToolbar = 31,
    BuildCustomizeMode = 32,
    PlayerChange = 33,
    PlayerProfile = 34,
    ObjectList = 35,
    PlayerDesire = 36,
    PlayerDesireList = 37,
    PlayerBuff = 38,
    PlayerBuffList = 39,
    PlayerInfo = 40,
    PlayerActionQueue = 41,
    CatOperator = 42,
    RemoteInteraction = 43,
    GameOption = 44,
    Smartphone = 45,
    FamilyMove = 46,
    FamilyMoveNewHouse = 47,
    DramaPopup = 48,
    FamilyEdit = 49,
    MoveTogether = 50,
    WeatherEdit = 51,
    SmartphoneCharacterSelect = 52,
    PlayerEmotionList = 53,
    FreeCamera = 54,
    CharacterCustomization = 55,
    ScheduleButton = 56,
    CommonPopup = 57,
    HopeOverHeadAlert = 58,
    RelationshipEffect = 59,
    Loading = 60,
    LoadingSubway = 61,
    TopMenu = 62,
    CatSelectedPlayerInfo = 63,
    ScheduleEdit = 64,
    ScheduleSelect = 65,
    CommonCatAlert = 66,
    SaveLoad = 67,
    SaveAs = 68,
    CatPopup = 69,
    FacialCapture = 70,
    ScheduleControl = 71,
    VideoPlay = 72,
    CatShop = 73,
    CommonBuyPopup = 74,
    CatShopBuyResult = 75,
    JobMission = 76,
    JobMissionButton = 77,
    PlayerNaviLayer = 78,
    EnvironmentEdit = 79,
    HideScreen = 80,
    OverlayLoading = 81,
    MoveTogetherDialog = 82,
    KeyGuidePopup = 83,
    FamilyMonitoring = 84,
    GoHomeAlert = 85,
    HomeButton = 86,
    Gallery = 87,
    CursorActorInfo = 88,
    RegionInfo = 89,
    RegionMessage = 90,
    Disclaimer = 91,
    GameIntroRating = 92,
    SmartphoneContact = 93,
    SmartphoneJobSearch = 94,
    SmartphoneMessage = 95,
    SmartphoneSendGiftToolTip = 96,
    CatTalk = 97,
    FadeInOut = 98,
    EnvironmentEditYoutube = 99,
    DreamBubble = 100,
    EnvironmentEditCityBalance = 101,
    SaveCharacterPreset = 102,
    UploadGallery = 103,
    ChangeFreeCameraGuide = 104,
    PhotoMode = 105,
    TraitSelect = 106,
    TraitDetailInfo = 107,
    SiteEdit = 108,
    SiteInfoEdit = 109,
    CaptureViewport = 110,
    BuildSavePreset = 111,
    StudioEdit = 112,
    EmergencyExit = 113,
    VehiclePurchase = 114,
    VehicleManagement = 115,
    VehicleInteraction = 116,
    VehicleNavigationDialog = 117,
    KarmaReport = 118,
    KarmaAction = 119,
    BodyTracking = 120,
    StudioVideoPlayer = 121,
    CityTheme = 122,
    HopeChange = 123,
    ScreenEffect = 124,
    CatOperatorTrait = 125,
    CatOperatorTraitDetailWidget = 126,
    CatOperatorPerspective = 127,
    CatOperatorPerspectiveDetailInfo = 128,
    CatOperatorHope = 129,
    CatOperatorHopeLife = 130,
    MainPerspectivePopup = 131,
    Build3DPrinter = 132,
    SkillChange = 133,
    FamilyInfo = 134,
    AmbitionPopup = 135,
    DebugEntity = 136,
    AITextureLoading = 137,
    HopeLife = 138,
    UIBlock = 139,
    ModList = 140,
    ModKitList = 141,
    GalleryAlertToast = 142,
    GalleryAlertOff = 143,
    SkillGauge = 144,
    CostumeEditCategory = 145,
    TimeController = 146,
    Crafting = 147,
    RelationshipProfile = 148,
    NumericPopup = 149,
    HudSkill = 150,
    CatOperatorSkill = 151,
    ChoiceCardPopup = 152,
    EducationRecruit = 153,
    SocialEventMain = 154,
    ScheduleEditAddEvent = 155,
    AIReason = 156,
    PocketMarket = 157,
    ZoiInformation = 158,
    SmartZoiPopup = 159,
    GenerateMotion = 160,
    AIMotionNamingPopup = 161,
    CoopRelationshipSelectZoi = 162,
    SocialEventRelationshipSelectZoi = 163,
    JobInformation = 164,
    SocialEventPopup = 165,
    SocialEventButton = 166,
    SocialEventActionPlayList = 167,
    KCNPopUp = 168,
    ObjectPopUpDescription = 169,
    LobbyButtonDiscord = 170,
    CraftingNaming = 171,
    BlockInput = 172,
    Max = 173,
}

---@enum EB1UpscalingMode
local EB1UpscalingMode = {
    None = 0,
    UltraPerformance = 1,
    Performance = 2,
    Balanced = 3,
    Quality = 4,
    NativeAA = 5,
    Auto = 6,
    EB1UpscalingMode_MAX = 7,
}

---@enum EB1VehicleCameraType
local EB1VehicleCameraType = {
    ThirdPerson = 0,
    Indoor = 1,
    EB1VehicleCameraType_MAX = 2,
}

---@enum EB1VehicleControlSubject
local EB1VehicleControlSubject = {
    Invalid = 0,
    Game = 1,
    Simulation = 2,
    EB1VehicleControlSubject_MAX = 3,
}

---@enum EB1VehicleLight
local EB1VehicleLight = {
    None = 0,
    RunningLights = 1,
    BrakeLights = 2,
    HazzardLights = 4,
    LeftTurnSignalLight = 8,
    RightTurnSignalLight = 16,
    HeadLights = 32,
    ReversingLights = 64,
    EB1VehicleLight_MAX = 65,
}

---@enum EB1VehicleMovableFlag
local EB1VehicleMovableFlag = {
    None = 0,
    RequestEnterVehiclePending = 1,
    WaitingForPassenger = 2,
    FreezeVehicleScript = 4,
    VehicleAccident = 8,
    MAX = 9,
}

---@enum EB1VehicleNavigationSkipResult
local EB1VehicleNavigationSkipResult = {
    Invalid = 0,
    Close = 1,
    NotFound = 2,
    Success = 3,
    EB1VehicleNavigationSkipResult_MAX = 4,
}

---@enum EB1VehiclePartActionType
local EB1VehiclePartActionType = {
    Invalid = 0,
    PlayStaticMeshAnim = 1,
    ReversePlayStaticMeshAnim = 2,
    StopStaticMeshAnim = 3,
    PlayVATAnim = 4,
    SetPrimitiveCustomData = 5,
    UnsetPrimitiveCustomData = 6,
    EB1VehiclePartActionType_MAX = 7,
}

---@enum EB1VehiclePartType
local EB1VehiclePartType = {
    Invalid = 0,
    DriverWindow = 1,
    Passenger0Window = 2,
    Passenger1Window = 3,
    Passenger2Window = 4,
    Trunk = 5,
    ConvertibleRoof = 6,
    Wiper = 7,
    HazzardLights = 8,
    LeftTurnSignalLight = 9,
    RightTurnSignalLight = 10,
    HeadLights = 11,
    RunningLights = 12,
    EB1VehiclePartType_MAX = 13,
}

---@enum EB1VehiclePolicy
local EB1VehiclePolicy = {
    Invalid = 0,
    Ghost = 1,
    Specific = 2,
    Control = 3,
    EB1VehiclePolicy_MAX = 4,
}

---@enum EB1VehiclePurchaseRejectReason
local EB1VehiclePurchaseRejectReason = {
    Invalid = 0,
    Underage = 1,
    Homeless = 2,
    LackOfGarage = 4,
    EB1VehiclePurchaseRejectReason_MAX = 5,
}

---@enum EB1VehicleRepresentationType
local EB1VehicleRepresentationType = {
    Invalid = 0,
    High = 1,
    Medium = 2,
    Low = 3,
    Off = 4,
    EB1VehicleRepresentationType_MAX = 5,
}

---@enum EB1VehicleSeat
local EB1VehicleSeat = {
    Invalid = 0,
    Driver = 1,
    Passenger0 = 2,
    Passenger1 = 3,
    Passenger2 = 4,
    EB1VehicleSeat_MAX = 5,
}

---@enum EB1VideoPlayerId
local EB1VideoPlayerId = {
    None = 0,
    LobbyIntro = 1,
    Intro = 2,
    ApprovalDocument = 3,
    PhotoStudioGuide = 4,
    CutSceneStudioProposeGuide = 5,
    CutSceneStudioMarriageGuide = 6,
    GhostProcedure = 7,
    NormalDeath = 8,
    EB1VideoPlayerId_MAX = 9,
}

---@enum EB1WeatherTriggerType
local EB1WeatherTriggerType = {
    None = 0,
    SeasonChanged = 1,
    WeatherChanged = 2,
    TemperatureRangeChanged = 3,
    GoOutSide = 4,
    GoInSide = 5,
    EB1WeatherTriggerType_MAX = 6,
}

---@enum EB1WeatherType
local EB1WeatherType = {
    None = 0,
    Sun = 1,
    Cloud = 2,
    Rain = 3,
    Snow = 4,
    EB1WeatherType_MAX = 5,
}

---@enum EB1WidgetCreationType
local EB1WidgetCreationType = {
    AutoCreatedAtStartup = 0,
    PlacedOnOtherWidget = 1,
    CreateManually = 2,
    LazyCreation = 3,
    EB1WidgetCreationType_MAX = 4,
}

---@enum EB1WorkState
local EB1WorkState = {
    Invalid = 0,
    Home = 1,
    PrepareGoWork = 2,
    Late = 3,
    Working = 4,
    EB1WorkState_MAX = 5,
}

---@enum EB1WorldMapFamilyMoveImpossibleReason
local EB1WorldMapFamilyMoveImpossibleReason = {
    None = 0,
    NotResidence = 1,
    AnotherFamilyAlreadyExists = 2,
    NotEnoughMoney = 3,
    MarriageFamilyAlreadyExists = 4,
    PlayingFamily = 5,
    Count = 6,
    EB1WorldMapFamilyMoveImpossibleReason_MAX = 7,
}

---@enum EB1WorldMissionCheckType
local EB1WorldMissionCheckType = {
    None = 0,
    Character = 1,
    Family = 2,
    World = 3,
    EB1WorldMissionCheckType_MAX = 4,
}

---@enum EB1WorldMissionId
local EB1WorldMissionId = {
    Invalid = 0,
    Max = 9223372036854775807,
}

---@enum EB1ZoiSelectFailReason
local EB1ZoiSelectFailReason = {
    None = 0,
    LowGrowthStep = 1,
    WalkToScheduleSite = 2,
    WorkingTime = 3,
    RabbitHole = 4,
    Sleeping = 5,
    SocialEvent = 6,
    InvalidTarget = 7,
    EB1ZoiSelectFailReason_MAX = 8,
}

---@enum EB1ZoneGrpahNodeType
local EB1ZoneGrpahNodeType = {
    Unset = 0,
    Door = 1,
    Stair = 2,
    Ladder = 3,
    EB1ZoneGrpahNodeType_MAX = 4,
}

---@enum EB2CraftBuildMode
local EB2CraftBuildMode = {
    None = 0,
    Printer = 1,
    Furniture = 2,
    Max = 3,
}

---@enum EB2EntityType
local EB2EntityType = {
    Invalid = 0,
    City = 1,
    Site = 2,
    Character = 3,
    GameObject = 4,
    HowlingEmitter = 5,
    Household = 6,
    Vehicle = 7,
    CoopScheduler = 8,
    Spawner = 9,
    Inventory = 10,
    EB2EntityType_MAX = 11,
}

---@enum EB2GameObjectDetailType
local EB2GameObjectDetailType = {
    Invalid = 0,
    None = 1,
    Book = 2,
    Food = 3,
    Door = 4,
    Stairs = 5,
    CarriableObject = 6,
    Dusty = 7,
    Roof = 8,
    Pillar = 9,
    Ladder = 10,
    Fence = 11,
    Fire = 12,
    Soot = 13,
    Printed = 14,
    StudioMannequin = 15,
    LocatorElevatorObject = 16,
    CraftObject = 17,
    NonCarriableCraftObject = 18,
    EB2GameObjectDetailType_MAX = 19,
}

---@enum EB2InitAutonomyIntervalType
local EB2InitAutonomyIntervalType = {
    Default = 0,
    ChangeSimulateOn = 1,
    InteractionFail = 2,
    TalkFinished = 3,
    ImmediateNextInteraction = 4,
    EB2InitAutonomyIntervalType_MAX = 5,
}

